/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.users;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.Suppliers;
import com.rulebricks.resources.users.groups.GroupsClient;
import com.rulebricks.resources.users.requests.CreateUserRequest;
import com.rulebricks.resources.users.requests.UserInviteRequest;
import com.rulebricks.types.CreateUserResponse;
import com.rulebricks.types.UserDetail;
import com.rulebricks.types.UserInviteResponse;
import java.util.List;
import java.util.function.Supplier;

public class UsersClient {
  protected final ClientOptions clientOptions;

  private final RawUsersClient rawClient;

  protected final Supplier<GroupsClient> groupsClient;

  public UsersClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new RawUsersClient(clientOptions);
    this.groupsClient = Suppliers.memoize(() -> new GroupsClient(clientOptions));
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public RawUsersClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Invite a new user to the organization or update role or access group data for an existing user.
   */
  public UserInviteResponse invite(UserInviteRequest request) {
    return this.rawClient.invite(request).body();
  }

  /**
   * Invite a new user to the organization or update role or access group data for an existing user.
   */
  public UserInviteResponse invite(UserInviteRequest request, RequestOptions requestOptions) {
    return this.rawClient.invite(request, requestOptions).body();
  }

  /**
   * List all users (including the admin and all team members) in the organization with their details including email, name, API key, role, access groups, and join date.
   */
  public List<UserDetail> list() {
    return this.rawClient.list().body();
  }

  /**
   * List all users (including the admin and all team members) in the organization with their details including email, name, API key, role, access groups, and join date.
   */
  public List<UserDetail> list(RequestOptions requestOptions) {
    return this.rawClient.list(requestOptions).body();
  }

  /**
   * Create a new user directly with a password, bypassing the email invitation flow. The user can immediately log in with the provided credentials.
   */
  public CreateUserResponse create(CreateUserRequest request) {
    return this.rawClient.create(request).body();
  }

  /**
   * Create a new user directly with a password, bypassing the email invitation flow. The user can immediately log in with the provided credentials.
   */
  public CreateUserResponse create(CreateUserRequest request, RequestOptions requestOptions) {
    return this.rawClient.create(request, requestOptions).body();
  }

  public GroupsClient groups() {
    return this.groupsClient.get();
  }
}
