/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = DynamicValue.Builder.class
)
public final class DynamicValue {
  private final String id;

  private final String name;

  private final String type;

  private final Optional<Object> value;

  private final Optional<List<RuleUsage>> usages;

  private final Optional<List<String>> accessGroups;

  private final Map<String, Object> additionalProperties;

  private DynamicValue(String id, String name, String type, Optional<Object> value,
      Optional<List<RuleUsage>> usages, Optional<List<String>> accessGroups,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.type = type;
    this.value = value;
    this.usages = usages;
    this.accessGroups = accessGroups;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Unique identifier for the dynamic value.
   */
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  /**
   * @return Name of the dynamic value (may include dot notation for nested properties).
   */
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  /**
   * @return Type identifier for the value (e.g., 'string', 'number', 'boolean', 'list', 'function', etc.)
   */
  @JsonProperty("type")
  public String getType() {
    return type;
  }

  /**
   * @return The actual value - can be any valid JSON type
   */
  @JsonProperty("value")
  public Optional<Object> getValue() {
    return value;
  }

  /**
   * @return Rules that use this dynamic value (only included when 'include=usage' parameter is used).
   */
  @JsonProperty("usages")
  public Optional<List<RuleUsage>> getUsages() {
    return usages;
  }

  /**
   * @return Access groups assigned to this value.
   */
  @JsonProperty("accessGroups")
  public Optional<List<String>> getAccessGroups() {
    return accessGroups;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof DynamicValue && equalTo((DynamicValue) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(DynamicValue other) {
    return id.equals(other.id) && name.equals(other.name) && type.equals(other.type) && value.equals(other.value) && usages.equals(other.usages) && accessGroups.equals(other.accessGroups);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.type, this.value, this.usages, this.accessGroups);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    /**
     * <p>Unique identifier for the dynamic value.</p>
     */
    NameStage id(@NotNull String id);

    Builder from(DynamicValue other);
  }

  public interface NameStage {
    /**
     * <p>Name of the dynamic value (may include dot notation for nested properties).</p>
     */
    TypeStage name(@NotNull String name);
  }

  public interface TypeStage {
    /**
     * <p>Type identifier for the value (e.g., 'string', 'number', 'boolean', 'list', 'function', etc.)</p>
     */
    _FinalStage type(@NotNull String type);
  }

  public interface _FinalStage {
    DynamicValue build();

    /**
     * <p>The actual value - can be any valid JSON type</p>
     */
    _FinalStage value(Optional<Object> value);

    _FinalStage value(Object value);

    /**
     * <p>Rules that use this dynamic value (only included when 'include=usage' parameter is used).</p>
     */
    _FinalStage usages(Optional<List<RuleUsage>> usages);

    _FinalStage usages(List<RuleUsage> usages);

    /**
     * <p>Access groups assigned to this value.</p>
     */
    _FinalStage accessGroups(Optional<List<String>> accessGroups);

    _FinalStage accessGroups(List<String> accessGroups);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, NameStage, TypeStage, _FinalStage {
    private String id;

    private String name;

    private String type;

    private Optional<List<String>> accessGroups = Optional.empty();

    private Optional<List<RuleUsage>> usages = Optional.empty();

    private Optional<Object> value = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(DynamicValue other) {
      id(other.getId());
      name(other.getName());
      type(other.getType());
      value(other.getValue());
      usages(other.getUsages());
      accessGroups(other.getAccessGroups());
      return this;
    }

    /**
     * <p>Unique identifier for the dynamic value.</p>
     * <p>Unique identifier for the dynamic value.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("id")
    public NameStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    /**
     * <p>Name of the dynamic value (may include dot notation for nested properties).</p>
     * <p>Name of the dynamic value (may include dot notation for nested properties).</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("name")
    public TypeStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    /**
     * <p>Type identifier for the value (e.g., 'string', 'number', 'boolean', 'list', 'function', etc.)</p>
     * <p>Type identifier for the value (e.g., 'string', 'number', 'boolean', 'list', 'function', etc.)</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("type")
    public _FinalStage type(@NotNull String type) {
      this.type = Objects.requireNonNull(type, "type must not be null");
      return this;
    }

    /**
     * <p>Access groups assigned to this value.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage accessGroups(List<String> accessGroups) {
      this.accessGroups = Optional.ofNullable(accessGroups);
      return this;
    }

    /**
     * <p>Access groups assigned to this value.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "accessGroups",
        nulls = Nulls.SKIP
    )
    public _FinalStage accessGroups(Optional<List<String>> accessGroups) {
      this.accessGroups = accessGroups;
      return this;
    }

    /**
     * <p>Rules that use this dynamic value (only included when 'include=usage' parameter is used).</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage usages(List<RuleUsage> usages) {
      this.usages = Optional.ofNullable(usages);
      return this;
    }

    /**
     * <p>Rules that use this dynamic value (only included when 'include=usage' parameter is used).</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "usages",
        nulls = Nulls.SKIP
    )
    public _FinalStage usages(Optional<List<RuleUsage>> usages) {
      this.usages = usages;
      return this;
    }

    /**
     * <p>The actual value - can be any valid JSON type</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage value(Object value) {
      this.value = Optional.ofNullable(value);
      return this;
    }

    /**
     * <p>The actual value - can be any valid JSON type</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "value",
        nulls = Nulls.SKIP
    )
    public _FinalStage value(Optional<Object> value) {
      this.value = value;
      return this;
    }

    @java.lang.Override
    public DynamicValue build() {
      return new DynamicValue(id, name, type, value, usages, accessGroups, additionalProperties);
    }
  }
}
