/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ValueLimits.Builder.class
)
public final class ValueLimits {
  private final Optional<Integer> maxKeys;

  private final Optional<Integer> maxValueLength;

  private final Optional<Integer> maxTotalSize;

  private final Optional<Integer> maxKeyLength;

  private final Map<String, Object> additionalProperties;

  private ValueLimits(Optional<Integer> maxKeys, Optional<Integer> maxValueLength,
      Optional<Integer> maxTotalSize, Optional<Integer> maxKeyLength,
      Map<String, Object> additionalProperties) {
    this.maxKeys = maxKeys;
    this.maxValueLength = maxValueLength;
    this.maxTotalSize = maxTotalSize;
    this.maxKeyLength = maxKeyLength;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Maximum number of value keys per user
   */
  @JsonProperty("MAX_KEYS")
  public Optional<Integer> getMaxKeys() {
    return maxKeys;
  }

  /**
   * @return Maximum length of a single value in characters
   */
  @JsonProperty("MAX_VALUE_LENGTH")
  public Optional<Integer> getMaxValueLength() {
    return maxValueLength;
  }

  /**
   * @return Maximum total size of all values in bytes
   */
  @JsonProperty("MAX_TOTAL_SIZE")
  public Optional<Integer> getMaxTotalSize() {
    return maxTotalSize;
  }

  /**
   * @return Maximum length of a key name
   */
  @JsonProperty("MAX_KEY_LENGTH")
  public Optional<Integer> getMaxKeyLength() {
    return maxKeyLength;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ValueLimits && equalTo((ValueLimits) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ValueLimits other) {
    return maxKeys.equals(other.maxKeys) && maxValueLength.equals(other.maxValueLength) && maxTotalSize.equals(other.maxTotalSize) && maxKeyLength.equals(other.maxKeyLength);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.maxKeys, this.maxValueLength, this.maxTotalSize, this.maxKeyLength);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<Integer> maxKeys = Optional.empty();

    private Optional<Integer> maxValueLength = Optional.empty();

    private Optional<Integer> maxTotalSize = Optional.empty();

    private Optional<Integer> maxKeyLength = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ValueLimits other) {
      maxKeys(other.getMaxKeys());
      maxValueLength(other.getMaxValueLength());
      maxTotalSize(other.getMaxTotalSize());
      maxKeyLength(other.getMaxKeyLength());
      return this;
    }

    /**
     * <p>Maximum number of value keys per user</p>
     */
    @JsonSetter(
        value = "MAX_KEYS",
        nulls = Nulls.SKIP
    )
    public Builder maxKeys(Optional<Integer> maxKeys) {
      this.maxKeys = maxKeys;
      return this;
    }

    public Builder maxKeys(Integer maxKeys) {
      this.maxKeys = Optional.ofNullable(maxKeys);
      return this;
    }

    /**
     * <p>Maximum length of a single value in characters</p>
     */
    @JsonSetter(
        value = "MAX_VALUE_LENGTH",
        nulls = Nulls.SKIP
    )
    public Builder maxValueLength(Optional<Integer> maxValueLength) {
      this.maxValueLength = maxValueLength;
      return this;
    }

    public Builder maxValueLength(Integer maxValueLength) {
      this.maxValueLength = Optional.ofNullable(maxValueLength);
      return this;
    }

    /**
     * <p>Maximum total size of all values in bytes</p>
     */
    @JsonSetter(
        value = "MAX_TOTAL_SIZE",
        nulls = Nulls.SKIP
    )
    public Builder maxTotalSize(Optional<Integer> maxTotalSize) {
      this.maxTotalSize = maxTotalSize;
      return this;
    }

    public Builder maxTotalSize(Integer maxTotalSize) {
      this.maxTotalSize = Optional.ofNullable(maxTotalSize);
      return this;
    }

    /**
     * <p>Maximum length of a key name</p>
     */
    @JsonSetter(
        value = "MAX_KEY_LENGTH",
        nulls = Nulls.SKIP
    )
    public Builder maxKeyLength(Optional<Integer> maxKeyLength) {
      this.maxKeyLength = maxKeyLength;
      return this;
    }

    public Builder maxKeyLength(Integer maxKeyLength) {
      this.maxKeyLength = Optional.ofNullable(maxKeyLength);
      return this;
    }

    public ValueLimits build() {
      return new ValueLimits(maxKeys, maxValueLength, maxTotalSize, maxKeyLength, additionalProperties);
    }
  }
}
