/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.assets;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.types.UsageStatistics;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawAssetsClient {
    protected final ClientOptions clientOptions;

    public AsyncRawAssetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<RulebricksApiHttpResponse<UsageStatistics>> getUsage() {
        return this.getUsage(null);
    }

    public CompletableFuture<RulebricksApiHttpResponse<UsageStatistics>> getUsage(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("admin/usage").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<RulebricksApiHttpResponse<UsageStatistics>> future = new CompletableFuture<RulebricksApiHttpResponse<UsageStatistics>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    String responseBodyString;
                    String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new RulebricksApiHttpResponse<UsageStatistics>((UsageStatistics)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UsageStatistics.class), response));
                        return;
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new RulebricksApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}

