/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.tests.rules;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.tests.rules.AsyncRawRulesClient;
import com.rulebricks.resources.tests.rules.requests.CreateRulesRequest;
import com.rulebricks.resources.tests.rules.requests.DeleteRulesRequest;
import com.rulebricks.resources.tests.rules.requests.ListRulesRequest;
import com.rulebricks.types.Test;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncRulesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawRulesClient rawClient;

    public AsyncRulesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawRulesClient(clientOptions);
    }

    public AsyncRawRulesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<List<Test>> list(String slug) {
        return this.rawClient.list(slug).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<Test>> list(String slug, ListRulesRequest request) {
        return this.rawClient.list(slug, request).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<Test>> list(String slug, ListRulesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(slug, request, requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<Test> create(String slug, CreateRulesRequest request) {
        return this.rawClient.create(slug, request).thenApply(response -> (Test)response.body());
    }

    public CompletableFuture<Test> create(String slug, CreateRulesRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(slug, request, requestOptions).thenApply(response -> (Test)response.body());
    }

    public CompletableFuture<Test> delete(String slug, String testId) {
        return this.rawClient.delete(slug, testId).thenApply(response -> (Test)response.body());
    }

    public CompletableFuture<Test> delete(String slug, String testId, DeleteRulesRequest request) {
        return this.rawClient.delete(slug, testId, request).thenApply(response -> (Test)response.body());
    }

    public CompletableFuture<Test> delete(String slug, String testId, DeleteRulesRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(slug, testId, request, requestOptions).thenApply(response -> (Test)response.body());
    }
}

