/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DecisionLog {
    private final Optional<OffsetDateTime> timestamp;
    private final Optional<String> name;
    private final Optional<String> endpoint;
    private final Optional<Integer> status;
    private final Optional<Map<String, Object>> request;
    private final Optional<Map<String, Object>> response;
    private final Optional<Map<String, Object>> decision;
    private final Optional<String> error;
    private final Optional<Boolean> abbreviated;
    private final Map<String, Object> additionalProperties;

    private DecisionLog(Optional<OffsetDateTime> timestamp, Optional<String> name, Optional<String> endpoint, Optional<Integer> status, Optional<Map<String, Object>> request, Optional<Map<String, Object>> response, Optional<Map<String, Object>> decision, Optional<String> error, Optional<Boolean> abbreviated, Map<String, Object> additionalProperties) {
        this.timestamp = timestamp;
        this.name = name;
        this.endpoint = endpoint;
        this.status = status;
        this.request = request;
        this.response = response;
        this.decision = decision;
        this.error = error;
        this.abbreviated = abbreviated;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getTimestamp() {
        if (this.timestamp == null) {
            return Optional.empty();
        }
        return this.timestamp;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getEndpoint() {
        if (this.endpoint == null) {
            return Optional.empty();
        }
        return this.endpoint;
    }

    @JsonIgnore
    public Optional<Integer> getStatus() {
        if (this.status == null) {
            return Optional.empty();
        }
        return this.status;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> getRequest() {
        if (this.request == null) {
            return Optional.empty();
        }
        return this.request;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> getResponse() {
        if (this.response == null) {
            return Optional.empty();
        }
        return this.response;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> getDecision() {
        if (this.decision == null) {
            return Optional.empty();
        }
        return this.decision;
    }

    @JsonIgnore
    public Optional<String> getError() {
        if (this.error == null) {
            return Optional.empty();
        }
        return this.error;
    }

    @JsonProperty(value="abbreviated")
    public Optional<Boolean> getAbbreviated() {
        return this.abbreviated;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="timestamp")
    private Optional<OffsetDateTime> _getTimestamp() {
        return this.timestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="endpoint")
    private Optional<String> _getEndpoint() {
        return this.endpoint;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="status")
    private Optional<Integer> _getStatus() {
        return this.status;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="request")
    private Optional<Map<String, Object>> _getRequest() {
        return this.request;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="response")
    private Optional<Map<String, Object>> _getResponse() {
        return this.response;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="decision")
    private Optional<Map<String, Object>> _getDecision() {
        return this.decision;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="error")
    private Optional<String> _getError() {
        return this.error;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DecisionLog && this.equalTo((DecisionLog)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DecisionLog other) {
        return this.timestamp.equals(other.timestamp) && this.name.equals(other.name) && this.endpoint.equals(other.endpoint) && this.status.equals(other.status) && this.request.equals(other.request) && this.response.equals(other.response) && this.decision.equals(other.decision) && this.error.equals(other.error) && this.abbreviated.equals(other.abbreviated);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.name, this.endpoint, this.status, this.request, this.response, this.decision, this.error, this.abbreviated);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<OffsetDateTime> timestamp = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> endpoint = Optional.empty();
        private Optional<Integer> status = Optional.empty();
        private Optional<Map<String, Object>> request = Optional.empty();
        private Optional<Map<String, Object>> response = Optional.empty();
        private Optional<Map<String, Object>> decision = Optional.empty();
        private Optional<String> error = Optional.empty();
        private Optional<Boolean> abbreviated = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DecisionLog other) {
            this.timestamp(other.getTimestamp());
            this.name(other.getName());
            this.endpoint(other.getEndpoint());
            this.status(other.getStatus());
            this.request(other.getRequest());
            this.response(other.getResponse());
            this.decision(other.getDecision());
            this.error(other.getError());
            this.abbreviated(other.getAbbreviated());
            return this;
        }

        @JsonSetter(value="timestamp", nulls=Nulls.SKIP)
        public Builder timestamp(Optional<OffsetDateTime> timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder timestamp(OffsetDateTime timestamp) {
            this.timestamp = Optional.ofNullable(timestamp);
            return this;
        }

        public Builder timestamp(Nullable<OffsetDateTime> timestamp) {
            this.timestamp = timestamp.isNull() ? null : (timestamp.isEmpty() ? Optional.empty() : Optional.of(timestamp.get()));
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="endpoint", nulls=Nulls.SKIP)
        public Builder endpoint(Optional<String> endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = Optional.ofNullable(endpoint);
            return this;
        }

        public Builder endpoint(Nullable<String> endpoint) {
            this.endpoint = endpoint.isNull() ? null : (endpoint.isEmpty() ? Optional.empty() : Optional.of(endpoint.get()));
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<Integer> status) {
            this.status = status;
            return this;
        }

        public Builder status(Integer status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Nullable<Integer> status) {
            this.status = status.isNull() ? null : (status.isEmpty() ? Optional.empty() : Optional.of(status.get()));
            return this;
        }

        @JsonSetter(value="request", nulls=Nulls.SKIP)
        public Builder request(Optional<Map<String, Object>> request) {
            this.request = request;
            return this;
        }

        public Builder request(Map<String, Object> request) {
            this.request = Optional.ofNullable(request);
            return this;
        }

        public Builder request(Nullable<Map<String, Object>> request) {
            this.request = request.isNull() ? null : (request.isEmpty() ? Optional.empty() : Optional.of(request.get()));
            return this;
        }

        @JsonSetter(value="response", nulls=Nulls.SKIP)
        public Builder response(Optional<Map<String, Object>> response) {
            this.response = response;
            return this;
        }

        public Builder response(Map<String, Object> response) {
            this.response = Optional.ofNullable(response);
            return this;
        }

        public Builder response(Nullable<Map<String, Object>> response) {
            this.response = response.isNull() ? null : (response.isEmpty() ? Optional.empty() : Optional.of(response.get()));
            return this;
        }

        @JsonSetter(value="decision", nulls=Nulls.SKIP)
        public Builder decision(Optional<Map<String, Object>> decision) {
            this.decision = decision;
            return this;
        }

        public Builder decision(Map<String, Object> decision) {
            this.decision = Optional.ofNullable(decision);
            return this;
        }

        public Builder decision(Nullable<Map<String, Object>> decision) {
            this.decision = decision.isNull() ? null : (decision.isEmpty() ? Optional.empty() : Optional.of(decision.get()));
            return this;
        }

        @JsonSetter(value="error", nulls=Nulls.SKIP)
        public Builder error(Optional<String> error) {
            this.error = error;
            return this;
        }

        public Builder error(String error) {
            this.error = Optional.ofNullable(error);
            return this;
        }

        public Builder error(Nullable<String> error) {
            this.error = error.isNull() ? null : (error.isEmpty() ? Optional.empty() : Optional.of(error.get()));
            return this;
        }

        @JsonSetter(value="abbreviated", nulls=Nulls.SKIP)
        public Builder abbreviated(Optional<Boolean> abbreviated) {
            this.abbreviated = abbreviated;
            return this;
        }

        public Builder abbreviated(Boolean abbreviated) {
            this.abbreviated = Optional.ofNullable(abbreviated);
            return this;
        }

        public DecisionLog build() {
            return new DecisionLog(this.timestamp, this.name, this.endpoint, this.status, this.request, this.response, this.decision, this.error, this.abbreviated, this.additionalProperties);
        }
    }
}

