/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.DecisionLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DecisionLogResponse {
    private final Optional<List<DecisionLog>> data;
    private final Optional<String> cursor;
    private final Optional<Integer> count;
    private final Map<String, Object> additionalProperties;

    private DecisionLogResponse(Optional<List<DecisionLog>> data, Optional<String> cursor, Optional<Integer> count, Map<String, Object> additionalProperties) {
        this.data = data;
        this.cursor = cursor;
        this.count = count;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="data")
    public Optional<List<DecisionLog>> getData() {
        return this.data;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonProperty(value="count")
    public Optional<Integer> getCount() {
        return this.count;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DecisionLogResponse && this.equalTo((DecisionLogResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DecisionLogResponse other) {
        return this.data.equals(other.data) && this.cursor.equals(other.cursor) && this.count.equals(other.count);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.cursor, this.count);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<DecisionLog>> data = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<Integer> count = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DecisionLogResponse other) {
            this.data(other.getData());
            this.cursor(other.getCursor());
            this.count(other.getCount());
            return this;
        }

        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public Builder data(Optional<List<DecisionLog>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<DecisionLog> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public Builder cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @JsonSetter(value="count", nulls=Nulls.SKIP)
        public Builder count(Optional<Integer> count) {
            this.count = count;
            return this;
        }

        public Builder count(Integer count) {
            this.count = Optional.ofNullable(count);
            return this;
        }

        public DecisionLogResponse build() {
            return new DecisionLogResponse(this.data, this.cursor, this.count, this.additionalProperties);
        }
    }
}

