/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.decisions.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.decisions.types.QueryDecisionsRequestCount;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class QueryDecisionsRequest {
    private final Optional<String> search;
    private final Optional<String> rules;
    private final Optional<String> statuses;
    private final Optional<OffsetDateTime> start;
    private final Optional<OffsetDateTime> end;
    private final Optional<String> cursor;
    private final Optional<Integer> limit;
    private final Optional<QueryDecisionsRequestCount> count;
    private final Optional<String> slug;
    private final Map<String, Object> additionalProperties;

    private QueryDecisionsRequest(Optional<String> search, Optional<String> rules, Optional<String> statuses, Optional<OffsetDateTime> start, Optional<OffsetDateTime> end, Optional<String> cursor, Optional<Integer> limit, Optional<QueryDecisionsRequestCount> count, Optional<String> slug, Map<String, Object> additionalProperties) {
        this.search = search;
        this.rules = rules;
        this.statuses = statuses;
        this.start = start;
        this.end = end;
        this.cursor = cursor;
        this.limit = limit;
        this.count = count;
        this.slug = slug;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="search")
    public Optional<String> getSearch() {
        return this.search;
    }

    @JsonProperty(value="rules")
    public Optional<String> getRules() {
        return this.rules;
    }

    @JsonProperty(value="statuses")
    public Optional<String> getStatuses() {
        return this.statuses;
    }

    @JsonProperty(value="start")
    public Optional<OffsetDateTime> getStart() {
        return this.start;
    }

    @JsonProperty(value="end")
    public Optional<OffsetDateTime> getEnd() {
        return this.end;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="count")
    public Optional<QueryDecisionsRequestCount> getCount() {
        return this.count;
    }

    @JsonProperty(value="slug")
    public Optional<String> getSlug() {
        return this.slug;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof QueryDecisionsRequest && this.equalTo((QueryDecisionsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(QueryDecisionsRequest other) {
        return this.search.equals(other.search) && this.rules.equals(other.rules) && this.statuses.equals(other.statuses) && this.start.equals(other.start) && this.end.equals(other.end) && this.cursor.equals(other.cursor) && this.limit.equals(other.limit) && this.count.equals(other.count) && this.slug.equals(other.slug);
    }

    public int hashCode() {
        return Objects.hash(this.search, this.rules, this.statuses, this.start, this.end, this.cursor, this.limit, this.count, this.slug);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> search = Optional.empty();
        private Optional<String> rules = Optional.empty();
        private Optional<String> statuses = Optional.empty();
        private Optional<OffsetDateTime> start = Optional.empty();
        private Optional<OffsetDateTime> end = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<QueryDecisionsRequestCount> count = Optional.empty();
        private Optional<String> slug = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(QueryDecisionsRequest other) {
            this.search(other.getSearch());
            this.rules(other.getRules());
            this.statuses(other.getStatuses());
            this.start(other.getStart());
            this.end(other.getEnd());
            this.cursor(other.getCursor());
            this.limit(other.getLimit());
            this.count(other.getCount());
            this.slug(other.getSlug());
            return this;
        }

        @JsonSetter(value="search", nulls=Nulls.SKIP)
        public Builder search(Optional<String> search) {
            this.search = search;
            return this;
        }

        public Builder search(String search) {
            this.search = Optional.ofNullable(search);
            return this;
        }

        @JsonSetter(value="rules", nulls=Nulls.SKIP)
        public Builder rules(Optional<String> rules) {
            this.rules = rules;
            return this;
        }

        public Builder rules(String rules) {
            this.rules = Optional.ofNullable(rules);
            return this;
        }

        @JsonSetter(value="statuses", nulls=Nulls.SKIP)
        public Builder statuses(Optional<String> statuses) {
            this.statuses = statuses;
            return this;
        }

        public Builder statuses(String statuses) {
            this.statuses = Optional.ofNullable(statuses);
            return this;
        }

        @JsonSetter(value="start", nulls=Nulls.SKIP)
        public Builder start(Optional<OffsetDateTime> start) {
            this.start = start;
            return this;
        }

        public Builder start(OffsetDateTime start) {
            this.start = Optional.ofNullable(start);
            return this;
        }

        @JsonSetter(value="end", nulls=Nulls.SKIP)
        public Builder end(Optional<OffsetDateTime> end) {
            this.end = end;
            return this;
        }

        public Builder end(OffsetDateTime end) {
            this.end = Optional.ofNullable(end);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="count", nulls=Nulls.SKIP)
        public Builder count(Optional<QueryDecisionsRequestCount> count) {
            this.count = count;
            return this;
        }

        public Builder count(QueryDecisionsRequestCount count) {
            this.count = Optional.ofNullable(count);
            return this;
        }

        @JsonSetter(value="slug", nulls=Nulls.SKIP)
        public Builder slug(Optional<String> slug) {
            this.slug = slug;
            return this;
        }

        public Builder slug(String slug) {
            this.slug = Optional.ofNullable(slug);
            return this;
        }

        public QueryDecisionsRequest build() {
            return new QueryDecisionsRequest(this.search, this.rules, this.statuses, this.start, this.end, this.cursor, this.limit, this.count, this.slug, this.additionalProperties);
        }
    }
}

