/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.SchemaFieldDefaultValue;
import com.rulebricks.types.SchemaFieldType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SchemaField {
    private final Optional<String> key;
    private final Optional<Boolean> show;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<SchemaFieldType> type;
    private final Optional<SchemaFieldDefaultValue> defaultValue;
    private final Optional<String> defaultComputedValue;
    private final Optional<String> transform;
    private final Map<String, Object> additionalProperties;

    private SchemaField(Optional<String> key, Optional<Boolean> show, Optional<String> name, Optional<String> description, Optional<SchemaFieldType> type, Optional<SchemaFieldDefaultValue> defaultValue, Optional<String> defaultComputedValue, Optional<String> transform, Map<String, Object> additionalProperties) {
        this.key = key;
        this.show = show;
        this.name = name;
        this.description = description;
        this.type = type;
        this.defaultValue = defaultValue;
        this.defaultComputedValue = defaultComputedValue;
        this.transform = transform;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="key")
    public Optional<String> getKey() {
        return this.key;
    }

    @JsonProperty(value="show")
    public Optional<Boolean> getShow() {
        return this.show;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="type")
    public Optional<SchemaFieldType> getType() {
        return this.type;
    }

    @JsonIgnore
    public Optional<SchemaFieldDefaultValue> getDefaultValue() {
        if (this.defaultValue == null) {
            return Optional.empty();
        }
        return this.defaultValue;
    }

    @JsonIgnore
    public Optional<String> getDefaultComputedValue() {
        if (this.defaultComputedValue == null) {
            return Optional.empty();
        }
        return this.defaultComputedValue;
    }

    @JsonProperty(value="transform")
    public Optional<String> getTransform() {
        return this.transform;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="defaultValue")
    private Optional<SchemaFieldDefaultValue> _getDefaultValue() {
        return this.defaultValue;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="defaultComputedValue")
    private Optional<String> _getDefaultComputedValue() {
        return this.defaultComputedValue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SchemaField && this.equalTo((SchemaField)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SchemaField other) {
        return this.key.equals(other.key) && this.show.equals(other.show) && this.name.equals(other.name) && this.description.equals(other.description) && this.type.equals(other.type) && this.defaultValue.equals(other.defaultValue) && this.defaultComputedValue.equals(other.defaultComputedValue) && this.transform.equals(other.transform);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.show, this.name, this.description, this.type, this.defaultValue, this.defaultComputedValue, this.transform);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> key = Optional.empty();
        private Optional<Boolean> show = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<SchemaFieldType> type = Optional.empty();
        private Optional<SchemaFieldDefaultValue> defaultValue = Optional.empty();
        private Optional<String> defaultComputedValue = Optional.empty();
        private Optional<String> transform = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SchemaField other) {
            this.key(other.getKey());
            this.show(other.getShow());
            this.name(other.getName());
            this.description(other.getDescription());
            this.type(other.getType());
            this.defaultValue(other.getDefaultValue());
            this.defaultComputedValue(other.getDefaultComputedValue());
            this.transform(other.getTransform());
            return this;
        }

        @JsonSetter(value="key", nulls=Nulls.SKIP)
        public Builder key(Optional<String> key) {
            this.key = key;
            return this;
        }

        public Builder key(String key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        @JsonSetter(value="show", nulls=Nulls.SKIP)
        public Builder show(Optional<Boolean> show) {
            this.show = show;
            return this;
        }

        public Builder show(Boolean show) {
            this.show = Optional.ofNullable(show);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<SchemaFieldType> type) {
            this.type = type;
            return this;
        }

        public Builder type(SchemaFieldType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="defaultValue", nulls=Nulls.SKIP)
        public Builder defaultValue(Optional<SchemaFieldDefaultValue> defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder defaultValue(SchemaFieldDefaultValue defaultValue) {
            this.defaultValue = Optional.ofNullable(defaultValue);
            return this;
        }

        public Builder defaultValue(Nullable<SchemaFieldDefaultValue> defaultValue) {
            this.defaultValue = defaultValue.isNull() ? null : (defaultValue.isEmpty() ? Optional.empty() : Optional.of(defaultValue.get()));
            return this;
        }

        @JsonSetter(value="defaultComputedValue", nulls=Nulls.SKIP)
        public Builder defaultComputedValue(Optional<String> defaultComputedValue) {
            this.defaultComputedValue = defaultComputedValue;
            return this;
        }

        public Builder defaultComputedValue(String defaultComputedValue) {
            this.defaultComputedValue = Optional.ofNullable(defaultComputedValue);
            return this;
        }

        public Builder defaultComputedValue(Nullable<String> defaultComputedValue) {
            this.defaultComputedValue = defaultComputedValue.isNull() ? null : (defaultComputedValue.isEmpty() ? Optional.empty() : Optional.of(defaultComputedValue.get()));
            return this;
        }

        @JsonSetter(value="transform", nulls=Nulls.SKIP)
        public Builder transform(Optional<String> transform) {
            this.transform = transform;
            return this;
        }

        public Builder transform(String transform) {
            this.transform = Optional.ofNullable(transform);
            return this;
        }

        public SchemaField build() {
            return new SchemaField(this.key, this.show, this.name, this.description, this.type, this.defaultValue, this.defaultComputedValue, this.transform, this.additionalProperties);
        }
    }
}

