/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.expression;

import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.exceptions.GenericSyntaxException;
import com.scriptbasic.exceptions.LexicalException;
import com.scriptbasic.executors.operators.AbstractBinaryOperator;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExpressionAnalyzer;
import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.syntax.AbstractAnalyzer;
import com.scriptbasic.utility.FactoryUtility;
import java.util.Map;

public abstract class AbstractExpressionAnalyzer
extends AbstractAnalyzer<Expression>
implements ExpressionAnalyzer {
    private Factory factory;

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    protected abstract Integer getMaximumPriority();

    protected abstract Map<String, Class<? extends AbstractBinaryOperator>> getOperatorMap(Integer var1);

    @Override
    public Expression analyze() throws AnalysisException {
        return this.analyze(this.getMaximumPriority());
    }

    private LexicalElement peekAtOperatorLexeme() throws AnalysisException {
        return FactoryUtility.getLexicalAnalyzer(this.factory).peek();
    }

    private LexicalElement consumeTheOperatorLexeme() throws AnalysisException {
        return FactoryUtility.getLexicalAnalyzer(this.factory).get();
    }

    private boolean isOperatorWithPriority(LexicalElement le, Integer priority) {
        return le != null && le.isSymbol() != false && this.getOperatorMap(priority).containsKey(le.getLexeme());
    }

    private Class<? extends AbstractBinaryOperator> getOperatorClass(LexicalElement le, Integer priority) {
        return this.getOperatorMap(priority).get(le.getLexeme());
    }

    private Expression analyzeWithPositivePriority(Integer priority) throws AnalysisException {
        Expression expression = null;
        Expression leftOperand = this.analyze(priority - 1);
        try {
            LexicalElement le;
            while (this.isOperatorWithPriority(le = this.peekAtOperatorLexeme(), priority)) {
                this.consumeTheOperatorLexeme();
                Expression rightOperand = this.analyze(priority - 1);
                AbstractBinaryOperator operator = this.getOperatorClass(le, priority).newInstance();
                operator.setLeftOperand(leftOperand);
                operator.setRightOperand(rightOperand);
                leftOperand = operator;
            }
            expression = leftOperand;
        }
        catch (LexicalException e) {
            throw new GenericSyntaxException(e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BasicInterpreterInternalError("Can not instantiate the operator class", e);
        }
        return expression;
    }

    private Expression analyze(Integer priority) throws AnalysisException {
        if (priority == 0) {
            return FactoryUtility.getTagAnalyzer(this.factory).analyze();
        }
        return this.analyzeWithPositivePriority(priority);
    }
}

