/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.interfaces.ExtendedInterpreter;
import com.scriptbasic.interfaces.InterpreterHook;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.utility.UtilityUtility;
import java.util.List;

public class HookRegisterUtility {
    private static Logger LOG = LoggerFactory.getLogger(HookRegisterUtility.class);

    private HookRegisterUtility() {
        UtilityUtility.throwExceptionToEnsureNobodyCallsIt();
    }

    public static void registerHooks(ExtendedInterpreter interpreter) {
        List<String> hookClassNameList = interpreter.getConfiguration().getConfigValueList("hook");
        if (hookClassNameList != null) {
            for (String hookClassName : hookClassNameList) {
                InterpreterHook hook = null;
                try {
                    hook = (InterpreterHook)Class.forName(hookClassName).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    LOG.error("Can not register the hook configured as '" + hookClassName + "'");
                }
                if (hook == null) continue;
                interpreter.registerHook(hook);
            }
        }
    }
}

