/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.memory;

import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.LocalVariableMap;
import com.scriptbasic.interfaces.RightValue;
import com.scriptbasic.memory.BasicVariableMap;
import com.scriptbasic.memory.BasicVariableRegistry;
import java.util.Stack;

public class BasicLocalVariableMap
extends BasicVariableMap
implements LocalVariableMap {
    private BasicVariableMap actualMap = null;
    private BasicVariableRegistry actualRegistry = null;
    private Stack<BasicVariableMap> localMapStack = new Stack();
    private Stack<BasicVariableRegistry> localRegistryStack = new Stack();

    @Override
    public RightValue getVariableValue(String variableName) throws ExecutionException {
        return this.actualMap == null ? null : this.actualMap.getVariableValue(variableName);
    }

    @Override
    public Boolean variableExists(String variableName) throws ExecutionException {
        return this.actualMap != null && this.actualMap.variableExists(variableName) != false;
    }

    @Override
    public Boolean variableDefined(String variableName) throws ExecutionException {
        return this.actualMap != null && this.actualMap.variableDefined(variableName) != false;
    }

    @Override
    public void setVariable(String variableName, RightValue rightValue) throws ExecutionException {
        if (this.actualMap == null) {
            throw new IllegalArgumentException("setting local variable '" + variableName + "' in non local scope");
        }
        this.actualMap.setVariable(variableName, rightValue);
    }

    @Override
    public void newFrame() {
        this.localMapStack.push(this.actualMap);
        this.localRegistryStack.push(this.actualRegistry);
        this.actualMap = new BasicVariableMap(this);
        this.actualRegistry = new BasicVariableRegistry(this.actualMap);
    }

    @Override
    public void dropFrame() {
        this.actualMap = this.localMapStack.pop();
        this.actualRegistry = this.localRegistryStack.pop();
    }

    public boolean currentScopeIsGlobal() {
        return this.localMapStack.isEmpty();
    }

    @Override
    public void registerGlobalVariable(String variableName) throws ExecutionException {
        if (this.actualRegistry != null) {
            this.actualRegistry.registerGlobal(variableName);
        }
    }

    @Override
    public void registerLocalVariable(String variableName) throws ExecutionException {
        if (this.actualRegistry == null) {
            throw new IllegalArgumentException("registering local variable +'" + variableName + "' in non local scope");
        }
        this.actualRegistry.registerLocal(variableName);
    }

    public boolean isGlobal(String variableName) throws ExecutionException {
        return this.actualRegistry != null && this.actualRegistry.isGlobal(variableName);
    }

    public boolean isLocal(String variableName) throws ExecutionException {
        return this.actualRegistry != null && this.actualRegistry.isLocal(variableName);
    }
}

