/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.exceptions.CommandFactoryException;
import com.scriptbasic.exceptions.KeywordNotImplementedException;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.Command;
import com.scriptbasic.interfaces.CommandAnalyzer;
import com.scriptbasic.interfaces.CommandFactory;
import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LineOrientedLexicalAnalyzer;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.syntax.commands.AbstractCommandAnalyzer;
import com.scriptbasic.syntax.commands.CommandAnalyzerCall;
import com.scriptbasic.syntax.commands.CommandAnalyzerElse;
import com.scriptbasic.syntax.commands.CommandAnalyzerElseIf;
import com.scriptbasic.syntax.commands.CommandAnalyzerEndIf;
import com.scriptbasic.syntax.commands.CommandAnalyzerEndSub;
import com.scriptbasic.syntax.commands.CommandAnalyzerFor;
import com.scriptbasic.syntax.commands.CommandAnalyzerGlobal;
import com.scriptbasic.syntax.commands.CommandAnalyzerIf;
import com.scriptbasic.syntax.commands.CommandAnalyzerLet;
import com.scriptbasic.syntax.commands.CommandAnalyzerLocal;
import com.scriptbasic.syntax.commands.CommandAnalyzerMethod;
import com.scriptbasic.syntax.commands.CommandAnalyzerNext;
import com.scriptbasic.syntax.commands.CommandAnalyzerPrint;
import com.scriptbasic.syntax.commands.CommandAnalyzerReturn;
import com.scriptbasic.syntax.commands.CommandAnalyzerSub;
import com.scriptbasic.syntax.commands.CommandAnalyzerUse;
import com.scriptbasic.syntax.commands.CommandAnalyzerWend;
import com.scriptbasic.syntax.commands.CommandAnalyzerWhile;
import com.scriptbasic.utility.FactoryUtility;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class BasicCommandFactory
implements CommandFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BasicCommandFactory.class);
    private Factory factory;
    private Map<String, CommandAnalyzer> classMap = new HashMap<String, CommandAnalyzer>();
    private List<CommandAnalyzer> classList = new LinkedList<CommandAnalyzer>();

    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
        this.registerCommandAnalyzer("while", new CommandAnalyzerWhile());
        this.registerCommandAnalyzer("wend", new CommandAnalyzerWend());
        this.registerCommandAnalyzer("if", new CommandAnalyzerIf());
        this.registerCommandAnalyzer("else", new CommandAnalyzerElse());
        this.registerCommandAnalyzer("elseif", new CommandAnalyzerElseIf());
        this.registerCommandAnalyzer("endif", new CommandAnalyzerEndIf());
        this.registerCommandAnalyzer("use", new CommandAnalyzerUse());
        this.registerCommandAnalyzer("method", new CommandAnalyzerMethod());
        this.registerCommandAnalyzer("sub", new CommandAnalyzerSub());
        this.registerCommandAnalyzer("endsub", new CommandAnalyzerEndSub());
        this.registerCommandAnalyzer("return", new CommandAnalyzerReturn());
        this.registerCommandAnalyzer("print", new CommandAnalyzerPrint());
        this.registerCommandAnalyzer("local", new CommandAnalyzerLocal());
        this.registerCommandAnalyzer("global", new CommandAnalyzerGlobal());
        this.registerCommandAnalyzer("call", new CommandAnalyzerCall());
        this.registerCommandAnalyzer("let", new CommandAnalyzerLet());
        this.registerCommandAnalyzer("for", new CommandAnalyzerFor());
        this.registerCommandAnalyzer("next", new CommandAnalyzerNext());
        this.registerCommandAnalyzer(new CommandAnalyzerLet());
        this.registerCommandAnalyzer(new CommandAnalyzerCall());
    }

    @Override
    public void registerCommandAnalyzer(String keyword, CommandAnalyzer analyzer) {
        LOG.info("Registering command {}", keyword);
        if (keyword == null) {
            this.classList.add(analyzer);
        } else {
            this.classMap.put(keyword, analyzer);
        }
        if (analyzer instanceof AbstractCommandAnalyzer) {
            if (this.getFactory() == null) {
                throw new BasicInterpreterInternalError("BasicCommandFactory's factory is null, not initialized yet");
            }
            ((AbstractCommandAnalyzer)analyzer).setFactory(this.getFactory());
        }
    }

    private void registerCommandAnalyzer(CommandAnalyzer analyzer) {
        this.registerCommandAnalyzer(null, analyzer);
    }

    @Override
    public Command create(String commandKeyword) throws AnalysisException {
        if (commandKeyword == null) {
            return this.create();
        }
        return this.createFromStartingSymbol(commandKeyword);
    }

    private Command create() throws AnalysisException {
        LexicalAnalyzer lexicalAnalyzer = FactoryUtility.getLexicalAnalyzer(this.getFactory());
        if (lexicalAnalyzer instanceof LineOrientedLexicalAnalyzer) {
            LineOrientedLexicalAnalyzer loLexicalAnalyzer = (LineOrientedLexicalAnalyzer)lexicalAnalyzer;
            for (CommandAnalyzer commandAnalyzer : this.classList) {
                try {
                    LOG.info("trying to analyze the line using {}", commandAnalyzer.getClass());
                    Command command = (Command)commandAnalyzer.analyze();
                    if (command != null) {
                        return command;
                    }
                }
                catch (AnalysisException e) {
                    LOG.info("Tried but not analyze the line using " + commandAnalyzer.getClass(), e);
                }
                loLexicalAnalyzer.resetLine();
            }
        }
        LOG.info("None of the analyzers could analyze the line", new Object[0]);
        throw new CommandFactoryException("The line could not be analyzed");
    }

    private Command createFromStartingSymbol(String commandKeyword) throws AnalysisException {
        String lowerCaseCommandKeyword = commandKeyword.toLowerCase();
        LOG.debug("Creating command starting with the keyword '{}'", lowerCaseCommandKeyword);
        if (!this.classMap.containsKey(lowerCaseCommandKeyword)) {
            throw new KeywordNotImplementedException(commandKeyword);
        }
        CommandAnalyzer commandAnalyzer = this.classMap.get(lowerCaseCommandKeyword);
        return (Command)commandAnalyzer.analyze();
    }
}

