/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors;

import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.MethodRegistry;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class BasicMethodRegistry
implements MethodRegistry {
    private Map<String, RegistryItem> registry = new HashMap<String, RegistryItem>();
    private Map<String, RegistryItem> globalRegistry = new HashMap<String, RegistryItem>();

    private static String formKey(String alias, Class<?> klass) {
        return alias + "#" + klass.getName().replaceAll("\\$", ".");
    }

    @Override
    public Method getJavaMethod(Class<?> klass, String alias) throws ExecutionException {
        Method method = null;
        if (klass == null) {
            method = this.getJavaMethod(alias);
        } else {
            RegistryItem item = this.registry.get(BasicMethodRegistry.formKey(alias, klass));
            if (item != null) {
                try {
                    method = item.klass.getMethod(item.methodName, item.args);
                }
                catch (Exception e) {
                    throw new BasicRuntimeException("Method '" + item.methodName + "' from class '" + item.klass + "' can not be accessed", e);
                }
            }
        }
        return method;
    }

    private Method getJavaMethod(String alias) throws ExecutionException {
        RegistryItem item = this.globalRegistry.get(alias);
        Method method = null;
        if (item != null) {
            try {
                method = item.klass.getMethod(item.methodName, item.args);
            }
            catch (Exception e) {
                throw new BasicRuntimeException("Method '" + item.methodName + "' from class '" + item.klass + "' can not be accessed", e);
            }
        }
        return method;
    }

    private boolean definitionIsTheSame(RegistryItem a, RegistryItem b) {
        return a.methodName.equals(b.methodName) && a.klass.equals(b.klass) && Arrays.equals(a.args, b.args);
    }

    private void registerGlobal(String alias, RegistryItem item) throws BasicRuntimeException {
        if (this.globalRegistry.containsKey(alias) && !this.definitionIsTheSame(this.globalRegistry.get(alias), item)) {
            throw new BasicRuntimeException("The BASIC function alias '" + alias + " can not be defined to point to the Java method '" + item.toString() + " because it is already defined to be " + this.globalRegistry.get(alias).toString());
        }
        this.globalRegistry.put(alias, item);
    }

    @Override
    public void registerJavaMethod(String alias, Class<?> klass, String methodName, Class<?>[] argumentTypes) throws BasicRuntimeException {
        RegistryItem item = new RegistryItem();
        item.methodName = methodName;
        item.klass = klass;
        RegistryItem.access$102(item, (Class[])argumentTypes.clone());
        this.registry.put(BasicMethodRegistry.formKey(alias, klass), item);
        this.registerGlobal(alias, item);
    }

    private static class RegistryItem {
        private String methodName;
        private Class<?> klass;
        private Class<?>[] args;

        private RegistryItem() {
        }

        public String toString() {
            String s = this.klass + "." + this.methodName + "(";
            String sep = "";
            for (Class<?> c : this.args) {
                s = s + sep + c.getName();
                sep = ",";
            }
            s = s + ")";
            return s;
        }

        static /* synthetic */ Class[] access$102(RegistryItem x0, Class[] x1) {
            x0.args = x1;
            return x1;
        }
    }
}

