/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.main;

import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class CommandLine {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("usage: java -jar jscriptbasic-x.y.z basicprogram.sb");
            System.exit(1);
        }
        Logger.getLogger("").setLevel(Level.SEVERE);
        String basicProgramFileName = args[0];
        int extensionDotPosition = basicProgramFileName.indexOf(46);
        String extension = extensionDotPosition > -1 ? basicProgramFileName.substring(extensionDotPosition + 1) : "";
        ScriptEngineManager sem = new ScriptEngineManager();
        ScriptEngine se = sem.getEngineByExtension(extension);
        if (se != null) {
            ScriptContext context = se.getContext();
            PrintWriter outWriter = new PrintWriter(System.out);
            context.setWriter(outWriter);
            PrintWriter errorWriter = new PrintWriter(System.err);
            context.setErrorWriter(errorWriter);
            context.setReader(new InputStreamReader(System.in));
            FileReader reader = new FileReader(basicProgramFileName);
            try {
                se.eval((Reader)reader, context);
            }
            catch (ScriptException sce) {
                Exception cause = (Exception)sce.getCause();
                if (cause == null) {
                    cause = sce;
                }
                if (cause.getMessage() != null) {
                    System.err.println("ERROR: " + cause.getMessage());
                }
                throw sce;
            }
            outWriter.flush();
            errorWriter.flush();
        } else {
            System.err.println("ERROR: There is no suitable interpreter for that file.");
        }
    }
}

