/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.executors.rightvalues.AbstractPrimitiveRightValue;
import com.scriptbasic.interfaces.RightValue;
import com.scriptbasic.utility.UtilityUtility;
import java.util.HashMap;
import java.util.Map;

public final class CastUtility {
    private static final Map<String, java.lang.Integer> castTypeNames = new HashMap<String, java.lang.Integer>();

    private CastUtility() {
        UtilityUtility.throwExceptionToEnsureNobodyCallsIt();
    }

    public static Object cast(Object object, Class<?> castTo) {
        Object result = object;
        try {
            if (castTypeNames.get(castTo.getName()) != null) {
                switch (castTypeNames.get(castTo.getName())) {
                    case 1: {
                        result = Byte.cast(object);
                        break;
                    }
                    case 2: {
                        result = Short.cast(object);
                        break;
                    }
                    case 3: {
                        result = Integer.cast(object);
                        break;
                    }
                    case 4: {
                        result = Long.cast(object);
                        break;
                    }
                    case 5: {
                        result = Float.cast(object);
                        break;
                    }
                    case 6: {
                        result = Double.cast(object);
                        break;
                    }
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return result;
    }

    public static Object toObject(RightValue rightValue) {
        return rightValue == null ? null : ((AbstractPrimitiveRightValue)rightValue).getValue();
    }

    static {
        int i = 1;
        for (String name : new String[]{"byte", "short", "int", "long", "float", "double"}) {
            castTypeNames.put(name, i);
            name = i == 3 ? "java.lang.Integer" : "java.lang." + name.substring(0, 1).toUpperCase() + name.substring(1);
            castTypeNames.put(name, i);
            ++i;
        }
    }

    private static class Double {
        private Double() {
        }

        static java.lang.Double cast(Object object) {
            return ((Number)object).doubleValue();
        }
    }

    private static class Float {
        private Float() {
        }

        static java.lang.Float cast(Object object) {
            return java.lang.Float.valueOf(((Number)object).floatValue());
        }
    }

    private static class Long {
        private Long() {
        }

        static java.lang.Long cast(Object object) {
            return ((Number)object).longValue();
        }
    }

    private static class Integer {
        private Integer() {
        }

        static java.lang.Integer cast(Object object) {
            return ((Number)object).intValue();
        }
    }

    private static class Short {
        private Short() {
        }

        static java.lang.Short cast(Object object) {
            return ((Number)object).shortValue();
        }
    }

    private static class Byte {
        private Byte() {
        }

        static java.lang.Byte cast(Object object) {
            return ((Number)object).byteValue();
        }
    }
}

