/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility.functions.file;

import com.scriptbasic.Function;
import com.scriptbasic.classification.File;
import com.scriptbasic.executors.rightvalues.BasicArrayValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.utility.UtilityUtility;
import com.scriptbasic.utility.functions.file.BinaryFileReader;
import com.scriptbasic.utility.functions.file.BinaryFileWriter;
import com.scriptbasic.utility.functions.file.FileHandler;
import com.scriptbasic.utility.functions.file.TextFileReader;
import com.scriptbasic.utility.functions.file.TextFileWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class FileHandlingFunctions {
    private FileHandlingFunctions() {
        UtilityUtility.throwExceptionToEnsureNobodyCallsIt();
    }

    private static String firstChar(StringBuilder sb) {
        String result = "";
        if (sb.length() > 0) {
            result = sb.substring(0, 1);
        }
        return result;
    }

    private static void chomp(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.delete(0, 1);
        }
    }

    private static String getABMode(StringBuilder sb, String ... a) {
        String result = null;
        String mode = FileHandlingFunctions.firstChar(sb);
        for (String m : a) {
            if (!m.equals(mode)) continue;
            FileHandlingFunctions.chomp(sb);
            result = m;
        }
        if (result == null) {
            result = a[0];
        }
        return result;
    }

    private static String fetchReadWriteMode(StringBuilder sb) {
        return FileHandlingFunctions.getABMode(sb, "r", "w", "a", "u");
    }

    private static String fetchTextBinaryMode(StringBuilder sb) {
        return FileHandlingFunctions.getABMode(sb, "t", "b");
    }

    private static FileHandler openTextFileForRead(String fileName) {
        TextFileReader result = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            result = new TextFileReader(br);
        }
        catch (FileNotFoundException fnfe) {
            result = null;
        }
        return result;
    }

    private static FileHandler openBinaryFileForRead(String fileName) {
        BinaryFileReader result = null;
        try {
            FileInputStream is = new FileInputStream(fileName);
            result = new BinaryFileReader(is);
        }
        catch (FileNotFoundException fnfe) {
            result = null;
        }
        return result;
    }

    private static FileHandler openTextFileForWrite(String fileName, boolean append) {
        TextFileWriter result = null;
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(fileName, append));
            result = new TextFileWriter(bw);
        }
        catch (IOException ioe) {
            result = null;
        }
        return result;
    }

    private static FileHandler openBinaryFileForWrite(String fileName, boolean append) {
        BinaryFileWriter result = null;
        try {
            BufferedOutputStream bw = new BufferedOutputStream(new FileOutputStream(fileName, append));
            result = new BinaryFileWriter(bw);
        }
        catch (IOException ioe) {
            result = null;
        }
        return result;
    }

    private static FileHandler openFileForRead(String fileName, boolean binary) {
        FileHandler result = null;
        result = binary ? FileHandlingFunctions.openBinaryFileForRead(fileName) : FileHandlingFunctions.openTextFileForRead(fileName);
        return result;
    }

    private static FileHandler openFileForWrite(String fileName, boolean append, boolean binary) {
        FileHandler result = null;
        result = binary ? FileHandlingFunctions.openBinaryFileForWrite(fileName, append) : FileHandlingFunctions.openTextFileForWrite(fileName, append);
        return result;
    }

    @Function(classification={File.class})
    public static FileHandler open(String fileName, String mode) {
        FileHandler result = null;
        StringBuilder sb = new StringBuilder(mode);
        String rwMode = FileHandlingFunctions.fetchReadWriteMode(sb);
        boolean append = rwMode.equals("a");
        boolean binary = FileHandlingFunctions.fetchTextBinaryMode(sb).equals("b");
        result = rwMode.equals("r") ? FileHandlingFunctions.openFileForRead(fileName, binary) : FileHandlingFunctions.openFileForWrite(fileName, append, binary);
        return result;
    }

    @Function(classification={File.class})
    public static String readLine(FileHandler fh) throws BasicRuntimeException, IOException {
        if (fh instanceof TextFileReader) {
            TextFileReader tfr = (TextFileReader)fh;
            return tfr.readLine();
        }
        throw new BasicRuntimeException("Binary reading line from file opened to write or being bindary.");
    }

    @Function(classification={File.class})
    public static byte[] read(FileHandler fh, int len) throws BasicRuntimeException, IOException {
        if (fh instanceof BinaryFileReader) {
            BinaryFileReader bfr = (BinaryFileReader)fh;
            return bfr.read(len);
        }
        throw new BasicRuntimeException("Binary reading from file opened to write or text.");
    }

    @Function(classification={File.class})
    public static void printf(FileHandler fh, String line) throws BasicRuntimeException, IOException {
        if (!(fh instanceof TextFileWriter)) {
            throw new BasicRuntimeException("Printing to a read only or binary file");
        }
        TextFileWriter tfw = (TextFileWriter)fh;
        tfw.print(line);
    }

    @Function(classification={File.class})
    public static void printfln(FileHandler fh, String line) throws IOException, BasicRuntimeException {
        FileHandlingFunctions.printf(fh, line);
        ((TextFileWriter)fh).newLine();
    }

    @Function(classification={File.class})
    public static void write(FileHandler fh, byte[] buffer) throws BasicRuntimeException, IOException {
        if (!(fh instanceof BinaryFileWriter)) {
            throw new BasicRuntimeException("Binary writing to a file opened to reads or text.");
        }
        BinaryFileWriter bfw = (BinaryFileWriter)fh;
        bfw.write(buffer);
    }

    @Function(classification={File.class})
    public static void close(FileHandler fh) throws Exception {
        fh.close();
    }

    @Function(classification={File.class})
    public static void deleteFile(String fileName) {
        new java.io.File(fileName).delete();
    }

    @Function(classification={File.class})
    public static boolean fileExists(String fileName) {
        return new java.io.File(fileName).exists();
    }

    @Function(classification={File.class})
    public static boolean fileCanExecute(String fileName) {
        return new java.io.File(fileName).canExecute();
    }

    @Function(classification={File.class})
    public static boolean fileIsReadable(String fileName) {
        return new java.io.File(fileName).canRead();
    }

    @Function(classification={File.class})
    public static boolean fileIsWritable(String fileName) {
        return new java.io.File(fileName).canWrite();
    }

    @Function(classification={File.class})
    public static boolean fileIsExecutable(String fileName) {
        return new java.io.File(fileName).canExecute();
    }

    @Function(classification={File.class})
    public static boolean isDirectory(String fileName) {
        return new java.io.File(fileName).isDirectory();
    }

    @Function(classification={File.class})
    public static boolean isFile(String fileName) {
        return new java.io.File(fileName).isDirectory();
    }

    @Function(classification={File.class})
    public static String absoluteFileName(String fileName) {
        return new java.io.File(fileName).getAbsolutePath();
    }

    @Function(classification={File.class})
    public static Long freeSpace(String fileName) {
        return new java.io.File(fileName).getFreeSpace();
    }

    @Function(classification={File.class})
    public static String parentDirectory(String fileName) {
        return new java.io.File(fileName).getParentFile().getAbsolutePath();
    }

    @Function(classification={File.class})
    public static boolean isHidden(String fileName) {
        return new java.io.File(fileName).isHidden();
    }

    @Function(classification={File.class})
    public static boolean mkdir(String fileName) {
        return new java.io.File(fileName).mkdirs();
    }

    @Function(classification={File.class})
    public static boolean renameFile(String fileNameFrom, String fileNameTo) {
        return new java.io.File(fileNameFrom).renameTo(new java.io.File(fileNameTo));
    }

    @Function(classification={File.class})
    public static boolean setExecutable(String fileName, boolean executable, boolean ownerOnly) {
        return new java.io.File(fileName).setExecutable(executable, ownerOnly);
    }

    @Function(classification={File.class})
    public static boolean setReadable(String fileName, boolean readable, boolean ownerOnly) {
        return new java.io.File(fileName).setReadable(readable, ownerOnly);
    }

    @Function(classification={File.class})
    public static boolean setWritable(String fileName, boolean writable, boolean ownerOnly) {
        return new java.io.File(fileName).setWritable(writable, ownerOnly);
    }

    @Function(classification={File.class})
    public static boolean setRedOnly(String fileName) {
        return new java.io.File(fileName).setReadOnly();
    }

    @Function(classification={File.class})
    public static Long lastModified(String fileName) {
        return new java.io.File(fileName).lastModified();
    }

    @Function(classification={File.class})
    public static Long fileLength(String fileName) {
        return new java.io.File(fileName).length();
    }

    @Function(classification={File.class})
    public static boolean setLastModified(String fileName, Long time) {
        return new java.io.File(fileName).setLastModified(time);
    }

    @Function(classification={File.class})
    public static BasicArrayValue listFiles(String fileName) throws ExecutionException {
        Object[] files = new java.io.File(fileName).list();
        BasicArrayValue result = new BasicArrayValue();
        result.setArray(files);
        return result;
    }
}

