/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.hooks;

import com.scriptbasic.executors.commands.CommandMethod;
import com.scriptbasic.executors.commands.CommandUse;
import com.scriptbasic.hooks.SimpleHook;
import com.scriptbasic.interfaces.Command;
import com.scriptbasic.interfaces.Configuration;
import java.util.Optional;

public class RunLimitHook
extends SimpleHook {
    private static final String configPrefix = "RunLimitHook.";
    private Configuration config;
    private int stepLimit;
    private boolean stepIsLimited;
    private int currentSteps;
    private long timeLimitMillis;
    private boolean timeIsLimited;
    private long scriptStartTime;
    private boolean allowMethodRegistering = true;

    private Optional<String> hookConfig(String s) {
        return this.config.getConfigValue(configPrefix + s);
    }

    @Override
    public void initEx() {
        this.config = this.getInterpreter().getConfiguration();
        this.currentSteps = 0;
        this.scriptStartTime = System.currentTimeMillis();
        Optional<String> stepLimit = this.hookConfig("stepLimit");
        this.stepIsLimited = stepLimit.isPresent();
        if (this.stepIsLimited) {
            this.stepLimit = Integer.valueOf(stepLimit.get());
        }
        Optional<String> timeLimitMillis = this.hookConfig("timeLimitMillis");
        this.timeIsLimited = timeLimitMillis.isPresent();
        if (this.timeIsLimited) {
            this.timeLimitMillis = Long.valueOf(timeLimitMillis.get());
        }
        this.allowMethodRegistering = this.hookConfig("allowJavaMethods").map(Boolean::valueOf).orElse(true);
    }

    @Override
    public void beforeExecuteEx(Command command) {
        if (this.stepIsLimited) {
            ++this.currentSteps;
            if (this.currentSteps > this.stepLimit) {
                throw new RuntimeException("The code exceeded the maximum number of steps");
            }
            if (!this.allowMethodRegistering && (command instanceof CommandMethod || command instanceof CommandUse)) {
                throw new RuntimeException("Registering Java methods is forbidden in the configuration");
            }
        }
        if (this.timeIsLimited && System.currentTimeMillis() - this.scriptStartTime > this.timeLimitMillis) {
            throw new RuntimeException("The code exceeded the maximum allowed time");
        }
    }
}

