/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.readers;

import com.scriptbasic.readers.HierarchicalSourceReader;
import com.scriptbasic.readers.SourceProvider;
import com.scriptbasic.readers.SourceReader;
import java.util.Stack;

public class GenericHierarchicalSourceReader
implements HierarchicalSourceReader {
    private final Stack<SourceReader> readerStack = new Stack();
    private SourceReader reader;

    public GenericHierarchicalSourceReader(SourceReader reader) {
        this.reader = reader;
    }

    @Override
    public void include(SourceReader reader) {
        if (this.reader != null) {
            this.readerStack.push(this.reader);
        }
        this.reader = reader;
    }

    @Override
    public String getFileName() {
        return this.reader.getFileName();
    }

    @Override
    public int getLineNumber() {
        return this.reader.getLineNumber();
    }

    @Override
    public int getPosition() {
        return this.reader.getPosition();
    }

    @Override
    public void unget(Integer ch) {
        this.reader.unget(ch);
    }

    @Override
    public Integer get() {
        Integer ch = this.reader.get();
        while (ch == null && !this.readerStack.isEmpty()) {
            this.reader = this.readerStack.pop();
            ch = this.reader.get();
        }
        return ch;
    }

    @Override
    public SourceProvider getSourceProvider() {
        return this.reader.getSourceProvider();
    }
}

