/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors;

import com.scriptbasic.api.Configuration;
import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.context.Context;
import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.executors.BasicMethodRegistry;
import com.scriptbasic.executors.commands.CommandSub;
import com.scriptbasic.hooks.NullHook;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.BuildableProgram;
import com.scriptbasic.interfaces.HierarchicalVariableMap;
import com.scriptbasic.interfaces.MethodRegistry;
import com.scriptbasic.memory.MixedBasicVariableMap;
import com.scriptbasic.spi.Command;
import com.scriptbasic.spi.Interpreter;
import com.scriptbasic.spi.InterpreterHook;
import com.scriptbasic.spi.RightValue;
import com.scriptbasic.utility.CastUtility;
import com.scriptbasic.utility.ExpressionUtility;
import com.scriptbasic.utility.HookRegisterUtility;
import com.scriptbasic.utility.MethodRegisterUtility;
import com.scriptbasic.utility.RightValueUtility;
import com.scriptbasic.utility.functions.BasicRuntimeFunctionRegisterer;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public final class BasicInterpreter
implements Interpreter {
    private final MixedBasicVariableMap variables = new MixedBasicVariableMap();
    private final Map<String, Object> interpreterStateMap = new HashMap<String, Object>();
    private final Map<String, Class<?>> useMap = new HashMap();
    private final MethodRegistry basicMethodRegistry = new BasicMethodRegistry();
    private final Stack<Command> commandStack = new Stack();
    private final Stack<Command> nextCommandStack = new Stack();
    private final Context ctx;
    private final List<Class<?>> deferredFunctionsRegistrations = new LinkedList();
    private final List<DeferredJavaMethodRegistration> deferredJavaMethodRegistrations = new LinkedList<DeferredJavaMethodRegistration>();
    private BuildableProgram program;
    private Reader reader;
    private Writer output;
    private Writer error;
    private InterpreterHook hook = null;
    private InterpreterHook hookedHook = null;
    private Command nextCommand;
    private Command currentCommand;
    private boolean executePreTask = true;
    private RightValue returnValue;

    public BasicInterpreter(Context ctx) {
        this.ctx = ctx;
        this.registerHook(new NullHook());
    }

    @Override
    public InterpreterHook getHook() {
        return this.hook;
    }

    @Override
    public void disableHook() {
        if (this.hook != null) {
            this.hookedHook = this.hook;
            this.hook = null;
        }
    }

    @Override
    public void enableHook() {
        if (this.hookedHook != null) {
            this.hook = this.hookedHook;
            this.hookedHook = null;
        }
    }

    @Override
    public void registerHook(InterpreterHook hook) {
        hook.setNext(this.hook);
        hook.setInterpreter(this);
        this.hook = hook;
    }

    @Override
    public Reader getInput() {
        return this.reader;
    }

    @Override
    public void setInput(Reader reader) {
        this.reader = reader;
    }

    @Override
    public Writer getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(Writer writer) {
        this.output = writer;
    }

    @Override
    public Writer getErrorOutput() {
        return this.error;
    }

    @Override
    public void setErrorOutput(Writer errorWriter) {
        this.error = errorWriter;
    }

    @Override
    public HierarchicalVariableMap getVariables() {
        return this.variables;
    }

    @Override
    public CommandSub getSubroutine(String name) {
        Command command = this.program.getNamedCommand(name);
        if (command instanceof CommandSub) {
            return (CommandSub)command;
        }
        return null;
    }

    @Override
    public void registerFunctions(Class<?> klass) {
        if (this.executePreTask) {
            this.deferredFunctionsRegistrations.add(klass);
        } else {
            try {
                MethodRegisterUtility.registerFunctions(klass, this);
            }
            catch (BasicRuntimeException e) {
                throw new BasicInterpreterInternalError("Registering functions from class '" + String.valueOf(klass) + "' caused exception. Probably double defining a function alias. Since this declared in Java code and not in BASIC this is an internal error of the embedding application. For more detail have a look at the exception that caused this.", e);
            }
        }
    }

    private void preExecuteTask() throws ScriptBasicException {
        if (this.executePreTask) {
            this.executePreTask = false;
            if (this.program == null) {
                throw new BasicRuntimeException("Program code was not loaded");
            }
            HookRegisterUtility.registerHooks(this);
            if (this.hook != null) {
                this.hook.init();
            }
            this.deferredFunctionsRegistrations.forEach(this::registerFunctions);
            this.deferredJavaMethodRegistrations.forEach(this::registerJavaMethod);
            BasicRuntimeFunctionRegisterer.registerBasicRuntimeFunctions(this);
        }
    }

    @Override
    public void execute() throws ScriptBasicException {
        this.preExecuteTask();
        Command command = this.program.getStartCommand();
        this.hook.beforeExecute();
        this.execute(command);
        this.hook.afterExecute();
    }

    @Override
    public void execute(Command startCommand) throws ScriptBasicException {
        this.preExecuteTask();
        Command command = startCommand;
        while (command != null) {
            this.nextCommand = command.getNextCommand();
            this.currentCommand = command;
            if (this.hook != null) {
                this.hook.beforeExecute(command);
            }
            command.checkedExecute(this);
            if (this.hook != null) {
                this.hook.afterExecute(command);
            }
            this.currentCommand = null;
            command = this.nextCommand;
        }
    }

    @Override
    public void setVariable(String name, Object value) throws ScriptBasicException {
        RightValue rightValue = RightValueUtility.createRightValue(value);
        this.getVariables().setVariable(name, rightValue);
    }

    @Override
    public Object getVariable(String name) throws ScriptBasicException {
        return CastUtility.toObject(this.getVariables().getVariableValue(name));
    }

    @Override
    public Object call(String functionName, Object[] arguments) throws ScriptBasicException {
        this.preExecuteTask();
        CommandSub commandSub = this.getSubroutine(functionName);
        if (commandSub == null) {
            throw new BasicRuntimeException("There is no such subroutine '" + functionName + "'");
        }
        return CastUtility.toObject(ExpressionUtility.callBasicFunction(this, RightValueUtility.createRightValues(arguments), commandSub, functionName));
    }

    @Override
    public BuildableProgram getProgram() {
        return this.program;
    }

    @Override
    public void setProgram(BuildableProgram buildableProgram) {
        this.program = buildableProgram;
    }

    @Override
    public void setNextCommand(Command nextCommand) {
        this.nextCommand = nextCommand;
    }

    @Override
    public Map<String, Object> getMap() {
        return this.interpreterStateMap;
    }

    @Override
    public Map<String, Class<?>> getUseMap() {
        return this.useMap;
    }

    @Override
    public Method getJavaMethod(Class<?> klass, String methodName) {
        return this.basicMethodRegistry.getJavaMethod(klass, methodName);
    }

    @Override
    public void registerJavaMethod(String alias, Class<?> klass, String methodName, Class<?>[] argumentTypes) throws BasicRuntimeException {
        if (this.executePreTask) {
            this.deferredJavaMethodRegistrations.add(DeferredJavaMethodRegistration.of(alias, klass, methodName, argumentTypes));
        } else {
            this.hook.beforeRegisteringJavaMethod(alias, klass, methodName, argumentTypes);
            this.basicMethodRegistry.registerJavaMethod(alias, klass, methodName, argumentTypes);
        }
    }

    private void registerJavaMethod(DeferredJavaMethodRegistration registration) {
        try {
            this.registerJavaMethod(registration.alias, registration.klass, registration.methodName, registration.argumentTypes);
        }
        catch (BasicRuntimeException e) {
            throw new BasicInterpreterInternalError("Registering method " + registration.klass.getName() + "." + registration.methodName + "' caused exception. Since this registration was executed from Java code before starting the actual BASIC program this is likely to be internal error of the embedding application. For more detail have a look at the exception that caused this.", e);
        }
    }

    @Override
    public void push(Command command) {
        if (this.hook != null) {
            this.hook.beforePush(command);
        }
        this.commandStack.push(command);
        this.nextCommandStack.push(this.nextCommand);
        this.getVariables().newFrame();
        if (this.hook != null) {
            this.hook.afterPush(command);
        }
    }

    @Override
    public void push() {
        this.push(this.currentCommand);
    }

    @Override
    public Command pop() {
        if (this.hook != null) {
            this.hook.beforePop();
        }
        this.getVariables().dropFrame();
        this.nextCommand = this.nextCommandStack.pop();
        Command command = this.commandStack.pop();
        if (this.hook != null) {
            this.hook.afterPop(command);
        }
        return command;
    }

    @Override
    public RightValue getReturnValue() {
        return this.returnValue;
    }

    @Override
    public void setReturnValue(RightValue returnValue) {
        this.returnValue = returnValue;
        if (this.hook != null) {
            this.hook.setReturnValue(returnValue);
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.ctx.configuration;
    }

    private static class DeferredJavaMethodRegistration {
        String alias;
        Class<?> klass;
        String methodName;
        Class<?>[] argumentTypes;

        private DeferredJavaMethodRegistration() {
        }

        static DeferredJavaMethodRegistration of(String alias, Class<?> klass, String methodName, Class<?>[] argumentTypes) {
            DeferredJavaMethodRegistration it = new DeferredJavaMethodRegistration();
            it.alias = alias;
            it.klass = klass;
            it.methodName = methodName;
            it.argumentTypes = argumentTypes;
            return it;
        }
    }
}

