/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.utils;

import com.securenative.config.SecureNativeOptions;
import com.securenative.utils.IPUtils;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class RequestUtils {
    public static final String SECURENATIVE_COOKIE = "_sn";
    public static final String SECURENATIVE_HEADER = "x-securenative";
    private static final List<String> ipHeaders = Arrays.asList("x-forwarded-for", "x-client-ip", "x-real-ip", "x-forwarded", "x-cluster-client-ip", "forwarded-for", "forwarded", "via");

    public static Map<String, String> getHeadersFromRequest(HttpServletRequest request) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            headersMap.put(headerName, headerValue);
        }
        return headersMap;
    }

    public static String getSecureHeaderFromRequest(Map<String, String> headers) {
        return headers.getOrDefault(SECURENATIVE_HEADER, "");
    }

    public static String getCookieValueFromRequest(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static String getClientIpFromRequest(HttpServletRequest request, Map<String, String> headers, SecureNativeOptions options) {
        if (options.getProxyHeaders().size() > 0) {
            for (String header : options.getProxyHeaders()) {
                String headerValue;
                Optional<String> ip;
                if (!headers.containsKey(header) || !(ip = Arrays.stream((headerValue = headers.get(header)).split(",")).map(String::trim).filter(IPUtils::isIpAddress).filter(IPUtils::isValidPublicIp).findFirst()).isPresent()) continue;
                return ip.get();
            }
        }
        Optional<String> bestCandidate = Optional.empty();
        for (String ipHeader : ipHeaders) {
            if (!headers.containsKey(ipHeader)) continue;
            String headerValue = headers.get(ipHeader);
            Optional<String> candidateIp = Arrays.stream(headerValue.split(",")).map(String::trim).filter(IPUtils::isIpAddress).filter(IPUtils::isValidPublicIp).findFirst();
            if (candidateIp.isPresent()) {
                return candidateIp.get();
            }
            if (bestCandidate.isPresent()) continue;
            bestCandidate = Arrays.stream(headerValue.split(",")).map(String::trim).filter(IPUtils::isLoopBack).findFirst();
        }
        return bestCandidate.orElseGet(() -> ((HttpServletRequest)request).getRemoteAddr());
    }

    public static String getRemoteIpFromRequest(HttpServletRequest request) {
        return request.getRemoteAddr();
    }
}

