/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.lang;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;

public class LOG {
    private static final long startTime = System.nanoTime();

    public static void d(String msg, Object ... args) {
        LOG.preprocessArgs(args);
        LOG.log(Severity.Debug, msg, args);
    }

    public static void d(Throwable e, String msg, Object ... args) {
        LOG.d(msg + "\n  " + LOG.toString(e).replace("\n", "\n  "), args);
    }

    private static void log(Severity debug, String msg, Object[] args) {
        String formatted = String.format(msg, args);
        StackTraceElement caller = Arrays.stream(Thread.currentThread().getStackTrace()).filter(stack -> {
            Class<?> clazz;
            try {
                clazz = Class.forName(stack.getClassName());
            }
            catch (Exception e) {
                return true;
            }
            if (clazz == Thread.class) {
                return false;
            }
            return clazz != LOG.class;
        }).findFirst().get();
        double time = (double)(System.nanoTime() - startTime) / 1.0E9;
        String line = String.format("[%.5f] (%s:%s) %s", time, caller.getFileName(), caller.getLineNumber(), formatted.replaceAll("\n", "\n\t"));
        System.out.println(line);
    }

    private static void preprocessArgs(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Class<?> c;
            if (null == args[i] || !(c = args[i].getClass()).isArray()) continue;
            args[i] = args[i] instanceof double[] ? LOG.toString((double[])args[i]) : (args[i] instanceof int[] ? Arrays.toString((int[])args[i]) : (args[i] instanceof long[] ? Arrays.toString((long[])args[i]) : (args[i] instanceof byte[] ? Arrays.toString((byte[])args[i]) : Arrays.toString((Object[])args[i]))));
        }
    }

    private static String toString(double[] point) {
        StringBuffer sb = new StringBuffer();
        for (double v : point) {
            if (0 < sb.length()) {
                sb.append(", ");
            }
            sb.append(String.format("%.3f", v));
        }
        return "[" + sb.toString() + "]";
    }

    public static String toString(Throwable e) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream s = new PrintStream(out);){
            e.printStackTrace(s);
        }
        String exception = out.toString();
        return exception;
    }

    public static enum Severity {
        Debug;

    }
}

