/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.lang;

import java.util.function.Supplier;

public class TimedResult<T> {
    public final T obj;
    public final long timeNanos;

    public TimedResult(T obj, long timeNanos) {
        this.obj = obj;
        this.timeNanos = timeNanos;
    }

    public static <T> TimedResult<T> time(Supplier<T> fn) {
        long start = System.nanoTime();
        T result = fn.get();
        return new TimedResult<T>(result, System.nanoTime() - start);
    }

    public double seconds() {
        return (double)this.timeNanos / 1.0E9;
    }
}

