/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.test;

import java.util.Iterator;
import java.util.List;

public class AsyncListIterator<T>
implements Iterator<T> {
    private final List<T> queue;
    private final Thread thread;
    int index = -1;

    public AsyncListIterator(List<T> queue, Thread thread) {
        this.thread = thread;
        this.queue = queue;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.queue.size() || this.thread.isAlive();
    }

    @Override
    public T next() {
        try {
            while (this.hasNext()) {
                if (++this.index < this.queue.size()) {
                    return this.queue.get(this.index);
                }
                Thread.sleep(100L);
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

