/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.test;

import com.simiacryptus.util.lang.TimedResult;
import com.simiacryptus.util.test.SysOutInterceptor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public class MarkdownPrintStream
extends PrintStream {
    private final List<PrintStream> teeStreams = new ArrayList<PrintStream>();
    private final File file;
    private final String methodName;
    private int imageNumber = 0;
    private static List<File> codeRoots = Arrays.asList("src/main/java", "src/test/java").stream().map(x -> new File((String)x)).collect(Collectors.toList());

    public static MarkdownPrintStream get(Object source) {
        try {
            StackTraceElement callingFrame = Thread.currentThread().getStackTrace()[2];
            String className = null == source ? callingFrame.getClassName() : source.getClass().getCanonicalName();
            String methodName = callingFrame.getMethodName();
            File path = new File(MarkdownPrintStream.mkString(File.separator, "reports", className, methodName + ".md"));
            path.getParentFile().mkdirs();
            return new MarkdownPrintStream(path, methodName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static String mkString(String separator, String ... strs) {
        return Arrays.asList(strs).stream().collect(Collectors.joining(separator));
    }

    public MarkdownPrintStream(File path, String methodName) throws FileNotFoundException {
        super(new FileOutputStream(path));
        this.methodName = methodName;
        this.file = path;
    }

    public MarkdownPrintStream addCopy(PrintStream out) {
        this.teeStreams.add(out);
        return this;
    }

    @Override
    public void println(String x) {
        super.println(x);
        this.teeStreams.forEach(t -> t.println(x));
    }

    public void out(String fmt, Object ... args) {
        this.println(0 == args.length ? fmt : String.format(fmt, args));
    }

    public void p(String fmt, Object ... args) {
        this.out(fmt + "\n", args);
    }

    public void h1(String fmt, Object ... args) {
        this.out("# " + fmt, args);
    }

    public void h2(String fmt, Object ... args) {
        this.out("## " + fmt, args);
    }

    public void h3(String fmt, Object ... args) {
        this.out("### " + fmt, args);
    }

    public <T> T code(Supplier<T> fn) {
        return this.code(fn, 16384, 3);
    }

    public <T> T code(Supplier<T> fn, int maxLog, int framesNo) {
        try {
            String valTxt;
            boolean escape;
            String str;
            ByteArrayOutputStream out;
            StackTraceElement callingFrame = Thread.currentThread().getStackTrace()[framesNo];
            String sourceCode = this.getInnerText(callingFrame);
            SysOutInterceptor.LoggedResult<TimedResult> result = SysOutInterceptor.withOutput(() -> {
                try {
                    return TimedResult.time(() -> MarkdownPrintStream.lambda$null$1((Supplier)fn));
                }
                catch (Throwable e) {
                    return new TimedResult<Throwable>(e, 0L);
                }
            });
            this.out("Code from [%s:%s](%s#L%s) executed in %.2f seconds: ", callingFrame.getFileName(), callingFrame.getLineNumber(), this.pathTo(this.file.getParentFile(), MarkdownPrintStream.findFile(callingFrame)), callingFrame.getLineNumber(), ((TimedResult)result.obj).seconds());
            this.out("```java", new Object[0]);
            this.out("  " + sourceCode.replaceAll("\n", "\n  "), new Object[0]);
            this.out("```", new Object[0]);
            if (!result.log.isEmpty()) {
                this.out("Logging: ", new Object[0]);
                this.out("```", new Object[0]);
                String logSrc = result.log;
                if (logSrc.length() > maxLog * 2) {
                    logSrc = logSrc.substring(0, maxLog) + String.format("\n...skipping %s bytes...\n", logSrc.length() - 2 * maxLog) + logSrc.substring(logSrc.length() - maxLog);
                } else if (logSrc.length() > 0) {
                    // empty if block
                }
                logSrc = logSrc.replaceAll("\n", "\n    ");
                this.out("    " + logSrc, new Object[0]);
                this.out("```", new Object[0]);
            }
            this.out("", new Object[0]);
            Object eval = ((TimedResult)result.obj).obj;
            this.out("Returns: ", new Object[0]);
            if (eval instanceof Throwable) {
                out = new ByteArrayOutputStream();
                ((Throwable)eval).printStackTrace(new PrintStream(out));
                str = new String(out.toByteArray(), "UTF-8");
                escape = true;
            } else if (eval instanceof BufferedImage) {
                out = new ByteArrayOutputStream();
                File file = new File(this.file.getParentFile(), this.methodName + "." + this.imageNumber++ + ".png");
                ImageIO.write((RenderedImage)((BufferedImage)eval), "png", file);
                str = "![Result](" + file.getName() + ")";
                escape = false;
            } else {
                str = eval.toString();
                escape = true;
            }
            if (escape) {
                this.out("```", new Object[0]);
            }
            String string = valTxt = escape ? str : str.replaceAll("\n", "\n    ");
            if (escape && valTxt.length() > maxLog) {
                valTxt = valTxt.substring(0, maxLog) + String.format("... and %s more bytes", valTxt.length() - maxLog);
            }
            this.out(escape ? "    " + valTxt : valTxt, new Object[0]);
            if (escape) {
                this.out("```", new Object[0]);
            }
            if (((TimedResult)result.obj).obj instanceof Throwable) {
                throw new RuntimeException((Throwable)((TimedResult)result.obj).obj);
            }
            return eval;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String pathTo(File from, File to) {
        Path fromUrl = from.toPath();
        Path toUrl = to.toPath();
        Path relativize = fromUrl.relativize(toUrl);
        return relativize.toString().replaceAll("\\\\", "/");
    }

    public void code(Runnable fn) {
        this.code(fn, 4096, 3);
    }

    public void code(Runnable fn, int maxLog, int framesNo) {
        try {
            StackTraceElement callingFrame = Thread.currentThread().getStackTrace()[framesNo];
            String sourceCode = this.getInnerText(callingFrame);
            TimedResult<SysOutInterceptor.LoggedResult> result = TimedResult.time(() -> SysOutInterceptor.withOutput(() -> fn.run()));
            this.out("Code from [%s:%s](%s#L%s) executed in %.2f seconds: ", callingFrame.getFileName(), callingFrame.getLineNumber(), this.pathTo(this.file.getParentFile(), MarkdownPrintStream.findFile(callingFrame)), callingFrame.getLineNumber(), result.seconds());
            this.out("```java", new Object[0]);
            this.out("  " + sourceCode.replaceAll("\n", "\n  "), new Object[0]);
            this.out("```", new Object[0]);
            if (!((SysOutInterceptor.LoggedResult)result.obj).log.isEmpty()) {
                this.out("Logging: ", new Object[0]);
                this.out("```", new Object[0]);
                String logSrc = ((SysOutInterceptor.LoggedResult)result.obj).log.replaceAll("\n", "\n    ");
                if (logSrc.length() > maxLog) {
                    logSrc = logSrc.substring(0, maxLog) + String.format("... and %s more bytes", logSrc.length() - maxLog);
                }
                this.out("    " + logSrc, new Object[0]);
                this.out("```", new Object[0]);
            }
            this.out("", new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getInnerText(StackTraceElement callingFrame) throws IOException {
        File file = MarkdownPrintStream.findFile(callingFrame);
        assert (null != file);
        int start = callingFrame.getLineNumber() - 1;
        int end = 3 + start;
        List<String> allLines = Files.readAllLines(file.toPath());
        List<String> window = allLines.subList(start, end);
        String txt = allLines.get(start);
        String indent = MarkdownPrintStream.getIndent(txt);
        ArrayList<String> lines = new ArrayList<String>();
        int i = start + 1;
        while (MarkdownPrintStream.getIndent(allLines.get(i)).length() > indent.length()) {
            lines.add(allLines.get(i).substring(indent.length()));
            ++i;
        }
        return lines.stream().collect(Collectors.joining("\n"));
    }

    private static File findFile(StackTraceElement callingFrame) {
        return MarkdownPrintStream.findFile(callingFrame.getClassName(), callingFrame.getFileName());
    }

    private static File findFile(String className, String fileName) {
        String[] packagePath = className.split("\\.");
        String path = Arrays.stream(packagePath).limit(packagePath.length - 1).collect(Collectors.joining(File.separator)) + File.separator + fileName;
        return MarkdownPrintStream.findFile(path);
    }

    private static String getIndent(String txt) {
        Matcher matcher = Pattern.compile("^\\s+").matcher(txt);
        return matcher.find() ? matcher.group(0) : "";
    }

    private static File findFile(String path) {
        for (File root : codeRoots) {
            File file = new File(root, path);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private static /* synthetic */ Object lambda$null$1(Supplier fn) {
        return fn.get();
    }
}

