/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.test;

import com.simiacryptus.util.test.AsyncListIterator;
import com.simiacryptus.util.test.Spool;
import com.simiacryptus.util.test.TestDocument;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WikiArticle
extends TestDocument {
    public static Loader ENGLISH = new Loader(URI.create("https://dumps.wikimedia.org/enwiki/latest/enwiki-latest-pages-articles.xml.bz2"), 10000);
    public static Loader GERMAN = new Loader(URI.create("https://dumps.wikimedia.org/dewiki/latest/dewiki-latest-pages-articles.xml.bz2"), 10000);
    public static Loader FRENCH = new Loader(URI.create("https://dumps.wikimedia.org/frwiki/latest/frwiki-latest-pages-articles.xml.bz2"), 10000);

    public WikiArticle(String title, String text) {
        super(title, text);
    }

    public static class Loader {
        private final String url;
        private final String file;
        private final int articleLimit;
        private volatile Thread thread;
        private final List<WikiArticle> queue = Collections.synchronizedList(new ArrayList());

        public Loader(URI uri, int articleLimit) {
            this.url = uri.toString();
            this.articleLimit = articleLimit;
            String path = uri.getPath();
            String[] split = path.split("/");
            this.file = split[split.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void clear() throws InterruptedException {
            if (this.thread == null) return;
            Class<WikiArticle> clazz = WikiArticle.class;
            synchronized (WikiArticle.class) {
                if (this.thread == null) return;
                this.thread.interrupt();
                this.thread.join();
                this.thread = null;
                this.queue.clear();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public Stream<WikiArticle> load() {
            if (this.thread == null) {
                Class<WikiArticle> clazz = WikiArticle.class;
                // MONITORENTER : com.simiacryptus.util.test.WikiArticle.class
                if (this.thread == null) {
                    this.thread = new Thread(this::read);
                    this.thread.setDaemon(true);
                    this.thread.start();
                }
                // MONITOREXIT : clazz
            }
            AsyncListIterator<WikiArticle> iterator = new AsyncListIterator<WikiArticle>(this.queue, this.thread);
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1), false).filter(x -> x != null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void read() {
            try (BZip2CompressorInputStream in = new BZip2CompressorInputStream(Spool.load(this.url, this.file), true);){
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(false);
                SAXParser saxParser = spf.newSAXParser();
                saxParser.parse((InputStream)in, new DefaultHandler(){
                    Stack<String> prefix = new Stack();
                    Stack<Map<String, AtomicInteger>> indexes = new Stack();
                    private String title;
                    StringBuilder nodeString = new StringBuilder();

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new RuntimeException(new InterruptedException());
                        }
                        this.nodeString.append(ch, start, length);
                        super.characters(ch, start, length);
                    }

                    @Override
                    public void endDocument() throws SAXException {
                        super.endDocument();
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new RuntimeException(new InterruptedException());
                        }
                        String pop = this.prefix.pop();
                        this.indexes.pop();
                        int length = this.nodeString.length();
                        String text = this.nodeString.toString().trim();
                        this.nodeString = new StringBuilder();
                        if ("page".equals(qName)) {
                            this.title = null;
                        } else if ("title".equals(qName)) {
                            this.title = text;
                        } else if ("text".equals(qName)) {
                            queue.add(new WikiArticle(this.title, text));
                            if (queue.size() > articleLimit) {
                                throw new RuntimeException(new InterruptedException());
                            }
                        }
                        super.endElement(uri, localName, qName);
                    }

                    @Override
                    public void startDocument() throws SAXException {
                        super.startDocument();
                    }

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        String path;
                        int idx;
                        if (Thread.currentThread().isInterrupted()) {
                            throw new RuntimeException(new InterruptedException());
                        }
                        if (0 < this.indexes.size()) {
                            Map<String, AtomicInteger> index = this.indexes.peek();
                            AtomicInteger cnt = index.get(qName);
                            if (null == cnt) {
                                cnt = new AtomicInteger(-1);
                                index.put(qName, cnt);
                            }
                            idx = cnt.incrementAndGet();
                        } else {
                            idx = 0;
                        }
                        String string = path = 0 == this.prefix.size() ? qName : this.prefix.peek() + "/" + qName;
                        if (0 < idx) {
                            path = path + "[" + idx + "]";
                        }
                        this.prefix.push(path);
                        this.indexes.push(new HashMap());
                        super.startElement(uri, localName, qName, attributes);
                    }
                }, null);
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof InterruptedException)) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                System.err.println("Read thread exit");
            }
        }
    }
}

