/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.text;

import com.davidehrmann.vcdiff.VCDiffDecoderBuilder;
import com.davidehrmann.vcdiff.VCDiffEncoder;
import com.davidehrmann.vcdiff.VCDiffEncoderBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class CompressionUtil {
    public static final Random random = new Random();

    public static byte[] encodeLZ(String data, String dictionary) {
        byte[] asBytes = new byte[]{};
        try {
            asBytes = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return CompressionUtil.encodeLZ(asBytes, dictionary);
    }

    public static byte[] encodeLZ(byte[] bytes) {
        return CompressionUtil.encodeLZ(bytes, "");
    }

    public static byte[] encodeLZ(byte[] bytes, String dictionary) {
        byte[] output = new byte[(int)((double)bytes.length * 1.05 + 32.0)];
        Deflater compresser = new Deflater();
        try {
            compresser.setInput(bytes);
            if (null != dictionary && !dictionary.isEmpty()) {
                byte[] bytes2 = dictionary.getBytes("UTF-8");
                compresser.setDictionary(bytes2);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        compresser.finish();
        int compressedDataLength = compresser.deflate(output);
        compresser.end();
        return Arrays.copyOf(output, compressedDataLength);
    }

    public static byte[] decodeLZ(byte[] data, String dictionary) {
        try {
            Inflater decompresser = new Inflater();
            decompresser.setInput(data, 0, data.length);
            byte[] result = new byte[data.length * 32];
            int resultLength = 0;
            if (!dictionary.isEmpty()) {
                resultLength = decompresser.inflate(result);
                assert (0 == resultLength);
                if (decompresser.needsDictionary()) {
                    byte[] bytes = dictionary.getBytes("UTF-8");
                    decompresser.setDictionary(bytes);
                }
            }
            resultLength = decompresser.inflate(result);
            decompresser.end();
            return Arrays.copyOfRange(result, 0, resultLength);
        }
        catch (UnsupportedEncodingException | DataFormatException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encodeLZ(String data) {
        return CompressionUtil.encodeLZ(data, "");
    }

    public static String decodeLZToString(byte[] data, String dictionary) {
        try {
            return new String(CompressionUtil.decodeLZ(data), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeLZToString(byte[] data) {
        try {
            return new String(CompressionUtil.decodeLZ(data), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decodeLZ(byte[] data) {
        return CompressionUtil.decodeLZ(data, "");
    }

    public static String decodeBZ(byte[] data) {
        try {
            return new String(CompressionUtil.decodeBZRaw(data), "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decodeBZRaw(byte[] data) {
        try {
            ByteArrayInputStream output = new ByteArrayInputStream(data);
            BZip2CompressorInputStream compresser = new BZip2CompressorInputStream((InputStream)output);
            return IOUtils.toByteArray((InputStream)compresser);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encodeBZ(String data) {
        try {
            byte[] bytes = CompressionUtil.encodeBZ(data.getBytes("UTF-8"));
            return bytes;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encodeBZ(byte[] data) {
        try {
            int blockSize = 4;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            BZip2CompressorOutputStream compresser = new BZip2CompressorOutputStream((OutputStream)output, blockSize);
            compresser.write(data);
            compresser.close();
            byte[] bytes = output.toByteArray();
            return bytes;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeBZ(byte[] data, String dictionary) {
        try {
            byte[] dictBytes = dictionary.getBytes("UTF-8");
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            VCDiffDecoderBuilder.builder().buildSimple().decode(dictBytes, CompressionUtil.decodeBZRaw(data), (OutputStream)buffer);
            return new String(buffer.toByteArray(), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encodeBZ(String data, String dictionary) {
        try {
            byte[] bytes = CompressionUtil.encodeBZ(data.getBytes("UTF-8"), dictionary);
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encodeBZ(byte[] asBytes, String dictionary) {
        try {
            byte[] dictBytes = dictionary.getBytes("UTF-8");
            VCDiffEncoder encoder = VCDiffEncoderBuilder.builder().withDictionary(dictBytes).buildSimple();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            encoder.encode(asBytes, (Object)buffer);
            return CompressionUtil.encodeBZ(buffer.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String displayStr(String str) {
        return str.replaceAll("\\\\", "\\\\").replaceAll("\n", "\\n").replaceAll("\u0000", "\\\\0");
    }
}

