/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.text;

import com.simiacryptus.util.binary.BitInputStream;
import com.simiacryptus.util.binary.BitOutputStream;
import com.simiacryptus.util.binary.Bits;
import com.simiacryptus.util.text.CharTrie;
import com.simiacryptus.util.text.TrieNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ConvolutionalTrieSerializer {
    private PrintStream verbose = null;

    public byte[] serialize(CharTrie charTrie) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (BitOutputStream out = new BitOutputStream(buffer);){
            int level = 0;
            while (this.serialize(charTrie.root(), out, level++) > 0) {
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buffer.toByteArray();
    }

    private int serialize(TrieNode root, BitOutputStream out, int level) {
        AtomicInteger nodesWritten = new AtomicInteger(0);
        if (0 == level) {
            TreeMap<Character, ? extends TrieNode> children = root.getChildrenMap();
            try {
                int size = children.size();
                out.writeVarLong(size);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            children.forEach((token, child) -> {
                try {
                    if (null != this.verbose) {
                        this.verbose.println(String.format("Write token %s", Character.valueOf(child.getChar())));
                    }
                    out.write(child.getChar());
                    out.writeVarLong(null == child ? 0L : child.getCursorCount());
                    nodesWritten.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        } else {
            HashMap godchildCounters = new HashMap();
            root.streamDecendents(level).forEach(node -> {
                AtomicLong nodeCounter = new AtomicLong();
                TrieNode godparent = node.getDepth() == 0 ? root : node.godparent();
                TreeMap<Character, ? extends TrieNode> godchildren = godparent.getChildrenMap();
                TreeMap<Character, ? extends TrieNode> children = node.getChildrenMap();
                try {
                    out.writeBoundedLong(children.size(), godchildren.size());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (null != this.verbose) {
                    this.verbose.println(String.format("Recursing %s with godparent %s and %s of %s potential children %s", node.getDebugString(), godparent.getDebugString(), children.size(), godchildren.size(), godchildren.keySet()));
                }
                godchildren.forEach((token, godchild) -> {
                    int godchildAdj = godchildCounters.getOrDefault(godchild.getDebugString(), 0);
                    TrieNode child = (TrieNode)children.get(token);
                    try {
                        long upperBound = this.getUpperBound((TrieNode)node, nodeCounter, (TrieNode)godchild, godchildAdj);
                        if (upperBound > 0L) {
                            if (null == child) {
                                if (null != this.verbose) {
                                    this.verbose.println(String.format("Write ZERO token %s", node.getDebugString() + godchild.getDebugToken()));
                                }
                                out.write(Bits.ZERO);
                            } else {
                                out.write(Bits.ONE);
                                long childCount = child.getCursorCount();
                                assert (childCount <= upperBound);
                                assert (childCount > 0L);
                                Bits bits = out.writeBoundedLong(childCount, upperBound);
                                if (null != this.verbose) {
                                    this.verbose.println(String.format("Write token %s = %s/%s -> %s", node.getDebugString() + godchild.getDebugToken(), childCount, upperBound, bits));
                                }
                                nodesWritten.incrementAndGet();
                                nodeCounter.addAndGet(childCount);
                                godchildCounters.put(godchild.getDebugString(), (int)((long)godchildAdj + childCount));
                            }
                        } else if (null != this.verbose) {
                            this.verbose.println(String.format("Implicit ZERO token %s", node.getDebugString() + godchild.getDebugToken()));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            });
        }
        return nodesWritten.get();
    }

    public CharTrie deserialize(byte[] bytes) {
        CharTrie trie = new CharTrie();
        BitInputStream in = new BitInputStream(new ByteArrayInputStream(bytes));
        int level = 0;
        while (this.deserialize(trie.root(), in, level++) > 0L) {
        }
        trie.recomputeCursorDetails();
        return trie;
    }

    private long deserialize(TrieNode root, BitInputStream in, int level) {
        AtomicLong nodesRead = new AtomicLong(0L);
        if (0 == level) {
            try {
                long numberOfChildren = in.readVarLong();
                TreeMap<Character, Long> children = new TreeMap<Character, Long>();
                int i = 0;
                while ((long)i < numberOfChildren) {
                    char c = (char)in.read(16).toLong();
                    long cnt = in.readVarLong();
                    if (null != this.verbose) {
                        this.verbose.println(String.format("Read char %s = %s", Character.valueOf(c), cnt));
                    }
                    children.put(Character.valueOf(c), cnt);
                    nodesRead.incrementAndGet();
                    ++i;
                }
                root.writeChildren(children);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            HashMap godchildCounters = new HashMap();
            root.streamDecendents(level).forEach(node -> {
                long numberOfChildren;
                TrieNode godparent;
                AtomicLong nodeCounter = new AtomicLong();
                TrieNode trieNode = godparent = node.getDepth() == 0 ? root : node.godparent();
                assert (1 >= node.getDepth() || node.getString().substring(1).equals(godparent.getString()));
                TreeMap<Character, ? extends TrieNode> godchildren = godparent.getChildrenMap();
                TreeMap<Character, Long> children = new TreeMap<Character, Long>();
                try {
                    numberOfChildren = in.readBoundedLong(godchildren.size());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (null != this.verbose) {
                    this.verbose.println(String.format("Recursing %s with godparent %s and %s of %s potential children %s", node.getDebugString(), godparent.getDebugString(), numberOfChildren, godchildren.size(), godchildren.keySet()));
                }
                godchildren.forEach((token, godchild) -> {
                    try {
                        int godchildAdj = godchildCounters.getOrDefault(godchild.getDebugString(), 0);
                        long upperBound = this.getUpperBound((TrieNode)node, nodeCounter, (TrieNode)godchild, godchildAdj);
                        if (upperBound > 0L) {
                            if (!in.readBool()) {
                                if (null != this.verbose) {
                                    this.verbose.println(String.format("Read ZERO token %s, input buffer = %s", node.getDebugString() + godchild.getDebugToken(), in.peek(24)));
                                }
                            } else {
                                long childCount = in.readBoundedLong(upperBound);
                                if (null != this.verbose) {
                                    this.verbose.println(String.format("Read token %s = %s/%s, input buffer = %s", node.getDebugString() + godchild.getDebugToken(), childCount, upperBound, in.peek(24)));
                                }
                                assert (childCount >= 0L);
                                children.put((Character)token, childCount);
                                nodesRead.incrementAndGet();
                                nodeCounter.addAndGet((int)childCount);
                                godchildCounters.put(godchild.getDebugString(), (int)((long)godchildAdj + childCount));
                            }
                        } else if (null != this.verbose) {
                            this.verbose.println(String.format("Implicit ZERO token %s, input buffer = %s", node.getDebugString() + godchild.getDebugToken(), in.peek(24)));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                node.writeChildren(children);
            });
        }
        return nodesRead.get();
    }

    protected long getUpperBound(TrieNode currentParent, AtomicLong currentChildren, TrieNode godchildNode, int godchildAdjustment) {
        return Math.min(currentParent.getCursorCount() - currentChildren.get(), godchildNode.getCursorCount() - (long)godchildAdjustment);
    }

    public PrintStream getVerbose() {
        return this.verbose;
    }

    public ConvolutionalTrieSerializer setVerbose(PrintStream verbose) {
        this.verbose = verbose;
        return this;
    }
}

