/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.text;

import com.simiacryptus.util.text.CharTrieIndex;
import com.simiacryptus.util.text.CursorData;

public class Cursor {
    private final CharTrieIndex charTrieIndex;
    final CursorData data;
    private final short depth;

    public Cursor(CharTrieIndex charTrieIndex, CursorData data, short depth) {
        this.charTrieIndex = charTrieIndex;
        this.data = data;
        this.depth = depth;
    }

    public String getDocument() {
        return this.charTrieIndex.documents.get(this.data.documentId);
    }

    public boolean hasNext() {
        return this.getPosition() + 1 < this.getDocument().length();
    }

    public char getToken() {
        String document;
        int index = this.getPosition();
        return index >= (document = this.getDocument()).length() ? (char)'\u0000' : document.charAt(index);
    }

    public Cursor next() {
        return new Cursor(this.charTrieIndex, this.data, (short)(this.depth + 1));
    }

    public int getPosition() {
        return this.data.position + this.depth - 1;
    }

    public int getDocumentId() {
        return this.data.documentId;
    }
}

