/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.text;

import com.simiacryptus.util.binary.BitInputStream;
import com.simiacryptus.util.binary.BitOutputStream;
import com.simiacryptus.util.binary.Bits;
import com.simiacryptus.util.binary.Interval;
import com.simiacryptus.util.text.CharTrie;
import com.simiacryptus.util.text.TrieNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Optional;

public class NodewalkerCodec {
    public static final Character ESCAPE = Character.valueOf('\ufffe');
    public static final char FALLBACK = '\uffff';
    public static final char END_OF_STRING = '\u0000';
    protected final CharTrie inner;
    protected PrintStream verbose = null;

    NodewalkerCodec(CharTrie inner) {
        this.inner = inner;
    }

    public String decodePPM(byte[] data, int context) {
        return new Decoder(data, context).encodePPM();
    }

    public Bits encodePPM(String text, int context) {
        return new Encoder(text, context).encodePPM();
    }

    public NodewalkerCodec setVerbose(PrintStream verbose) {
        this.verbose = verbose;
        return this;
    }

    protected void writeForward(Encoder encoder) throws IOException {
        if (encoder.node.index != encoder.fromNode.index) {
            Bits bits = encoder.fromNode.bitsTo(encoder.node);
            short count = (short)(encoder.node.getDepth() - encoder.fromNode.getDepth());
            if (this.verbose != null) {
                this.verbose.println(String.format("Writing %s forward from %s to %s = %s", count, encoder.fromNode.getDebugString(), encoder.node.getDebugString(), bits));
            }
            encoder.out.writeVarShort(count, 3);
            encoder.out.write(bits);
        } else {
            assert (0 == encoder.node.index);
            encoder.out.writeVarShort((short)0, 3);
        }
    }

    protected void readForward(Decoder decoder) throws IOException {
        short numberOfTokens = decoder.in.readVarShort(3);
        if (0 < numberOfTokens) {
            long seek = decoder.in.peekLongCoord(decoder.node.getCursorCount());
            TrieNode toNode = decoder.node.traverse(seek + decoder.node.getCursorIndex());
            while (toNode.getDepth() > decoder.node.getDepth() + numberOfTokens) {
                toNode = toNode.getParent();
            }
            Interval interval = decoder.node.intervalTo(toNode);
            String str = toNode.getString(decoder.node);
            Bits bits = interval.toBits();
            if (this.verbose != null) {
                this.verbose.println(String.format("Read %s forward from %s to %s = %s", numberOfTokens, decoder.node.getDebugString(), toNode.getDebugString(), bits));
            }
            decoder.in.expect(bits);
            decoder.out.append(str);
            decoder.node = toNode;
        } else assert (0 == decoder.node.index);
    }

    protected Optional<TrieNode> writeBackup(Encoder encoder, char token) throws IOException {
        Optional<Object> child = Optional.empty();
        while (!child.isPresent()) {
            encoder.node = encoder.node.godparent();
            if (encoder.node == null) break;
            child = encoder.node.getChild(token);
        }
        assert (null == encoder.node || child.isPresent());
        if (null != encoder.node) {
            for (int i = 0; i < 2; ++i) {
                if (0 == encoder.node.index) continue;
                encoder.node = encoder.node.godparent();
            }
            child = encoder.node.getChild(token);
            while (!child.isPresent()) {
                encoder.node = encoder.node.godparent();
                if (encoder.node == null) break;
                child = encoder.node.getChild(token);
            }
            assert (null == encoder.node || child.isPresent());
        }
        short backupSteps = (short)(encoder.fromNode.getDepth() - (null == encoder.node ? -1 : (int)encoder.node.getDepth()));
        assert (backupSteps >= 0);
        if (this.verbose != null) {
            this.verbose.println(String.format("Backing up %s from from %s to %s", backupSteps, encoder.fromNode.getDebugString(), null == encoder.node ? null : encoder.node.getDebugString()));
        }
        encoder.out.writeVarShort(backupSteps, 3);
        return child;
    }

    protected boolean readBackup(Decoder decoder) throws IOException {
        int numberOfBackupSteps = decoder.in.readVarShort(3);
        TrieNode fromNode = decoder.node;
        if (0 == numberOfBackupSteps) {
            return true;
        }
        for (int i = 0; i < numberOfBackupSteps; ++i) {
            decoder.node = decoder.node.godparent();
        }
        if (this.verbose != null) {
            this.verbose.println(String.format("Backing up %s from from %s to %s", (short)numberOfBackupSteps, fromNode.getDebugString(), decoder.node.getDebugString()));
        }
        return false;
    }

    protected void writeTerminal(Encoder encoder) throws IOException {
        if (this.verbose != null) {
            this.verbose.println(String.format("Writing forward to end from %s to %s", encoder.fromNode.getDebugString(), encoder.node.getDebugString()));
        }
        encoder.out.writeVarShort((short)(encoder.node.getDepth() - encoder.fromNode.getDepth()), 3);
        encoder.out.write(encoder.fromNode.bitsTo(encoder.node));
        encoder.out.writeVarShort((short)0, 3);
    }

    protected class Encoder {
        protected String text;
        protected int context;
        protected ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        protected BitOutputStream out = new BitOutputStream(this.buffer);
        protected TrieNode node;
        protected TrieNode fromNode;

        protected Encoder(String text, int context) {
            this.node = NodewalkerCodec.this.inner.root();
            this.fromNode = NodewalkerCodec.this.inner.root();
            if (!text.endsWith("\u0000")) {
                text = text + '\u0000';
            }
            this.text = text;
            this.context = context;
        }

        protected Bits encodePPM() {
            try {
                for (char token : this.text.toCharArray()) {
                    Optional<? extends TrieNode> child = this.node.getChild(token);
                    if (!child.isPresent()) {
                        NodewalkerCodec.this.writeForward(this);
                        this.fromNode = this.node;
                        child = NodewalkerCodec.this.writeBackup(this, token);
                        if (null == this.node) {
                            if (NodewalkerCodec.this.verbose != null) {
                                NodewalkerCodec.this.verbose.println(String.format("Literal token %s", Character.valueOf(token)));
                            }
                            this.out.write(token);
                            this.node = this.fromNode = NodewalkerCodec.this.inner.root();
                            continue;
                        }
                        this.fromNode = this.node;
                        this.node = child.get();
                        continue;
                    }
                    this.node = child.get();
                }
                NodewalkerCodec.this.writeTerminal(this);
                this.out.flush();
                Bits bits = new Bits(this.buffer.toByteArray(), this.out.getTotalBitsWritten());
                return bits;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected class Decoder {
        protected byte[] data;
        protected int context;
        protected BitInputStream in;
        protected StringBuilder out;
        protected TrieNode node;

        protected Decoder(byte[] data, int context) {
            this.in = new BitInputStream(new ByteArrayInputStream(this.data));
            this.out = new StringBuilder();
            this.node = NodewalkerCodec.this.inner.root();
            this.data = data;
            this.context = context;
        }

        protected String encodePPM() {
            try {
                do {
                    if (null == this.node) {
                        char c = this.in.readChar();
                        this.out.append(c);
                        if (NodewalkerCodec.this.verbose != null) {
                            NodewalkerCodec.this.verbose.println(String.format("Literal token %s", Character.valueOf(c)));
                        }
                        this.node = NodewalkerCodec.this.inner.root();
                    }
                    NodewalkerCodec.this.readForward(this);
                } while (!NodewalkerCodec.this.readBackup(this));
                return this.out.toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

