/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.text;

import com.simiacryptus.util.binary.BitInputStream;
import com.simiacryptus.util.binary.BitOutputStream;
import com.simiacryptus.util.binary.Bits;
import com.simiacryptus.util.binary.Interval;
import com.simiacryptus.util.text.CharTrie;
import com.simiacryptus.util.text.TrieNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Optional;

public class PPMCodec {
    public static final Character ESCAPE = Character.valueOf('\ufffe');
    public static final char FALLBACK = '\uffff';
    public static final char END_OF_STRING = '\u0000';
    final CharTrie inner;
    public boolean verbose = false;

    PPMCodec(CharTrie inner) {
        this.inner = inner;
    }

    private static String getRight(String str, int count) {
        int newLen = Math.min(count, str.length());
        int prefixFrom = Math.max(0, str.length() - newLen);
        String right = str.substring(prefixFrom, str.length());
        return right;
    }

    public String decodePPM(byte[] data, int context) {
        try {
            StringBuilder out;
            block16: {
                BitInputStream in = new BitInputStream(new ByteArrayInputStream(data));
                out = new StringBuilder();
                String contextStr = "";
                while (true) {
                    TrieNode fromNode;
                    if (0 == (fromNode = this.inner.matchPredictor(PPMCodec.getRight(contextStr, context))).getNumberOfChildren()) {
                        return "";
                    }
                    long seek = in.peekLongCoord(fromNode.getCursorCount());
                    TrieNode toNode = fromNode.traverse(seek + fromNode.getCursorIndex());
                    String newSegment = toNode.getString(fromNode);
                    Interval interval = fromNode.intervalTo(toNode);
                    Bits bits = interval.toBits();
                    if (this.verbose) {
                        System.out.println(String.format("Using prefix \"%s\", seek to %s pos, path \"%s\" with %s -> %s, input buffer = %s", fromNode.getDebugString(), seek, toNode.getDebugString(fromNode), interval, bits, in.peek(24)));
                    }
                    in.expect(bits);
                    if (toNode.isStringTerminal()) {
                        if (this.verbose) {
                            System.out.println("Inserting null char to terminate string");
                        }
                        newSegment = newSegment + '\u0000';
                    }
                    if (!newSegment.isEmpty()) {
                        if (newSegment.endsWith("\u0000")) {
                            out.append(newSegment.substring(0, newSegment.length() - 1));
                            if (this.verbose) {
                                System.out.println(String.format("Null char reached", new Object[0]));
                            }
                            break block16;
                        }
                        contextStr = contextStr + newSegment;
                        out.append(newSegment);
                        continue;
                    }
                    if (in.availible() == 0) {
                        if (this.verbose) {
                            System.out.println(String.format("No More Data", new Object[0]));
                        }
                        break block16;
                    }
                    if (toNode.getChar() == '\u0000') {
                        if (this.verbose) {
                            System.out.println(String.format("End code", new Object[0]));
                        }
                        break block16;
                    }
                    if (toNode.getChar() == '\uffff') {
                        contextStr = fromNode.getString().substring(1);
                        continue;
                    }
                    if (toNode.getChar() != ESCAPE.charValue()) break;
                    Bits charBits = in.read(16);
                    char exotic = (char)charBits.toLong();
                    out.append(new String(new char[]{exotic}));
                    if (!this.verbose) continue;
                    System.out.println(String.format("Read exotic byte %s -> %s, input buffer = %s", Character.valueOf(exotic), charBits, in.peek(24)));
                }
                if (this.verbose) {
                    System.out.println(String.format("Cannot decode text", new Object[0]));
                }
            }
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Bits encodePPM(String text, int context) {
        String original = text;
        if (!text.endsWith("\u0000")) {
            text = text + '\u0000';
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        BitOutputStream out = new BitOutputStream(buffer);
        String contextStr = "";
        try {
            while (!text.isEmpty()) {
                String right = PPMCodec.getRight(contextStr, context);
                TrieNode fromNode = this.inner.matchPredictor(right);
                String prefix = fromNode.getString();
                TrieNode toNode = fromNode.traverse(text);
                int segmentChars = toNode.getDepth() - fromNode.getDepth();
                if (toNode.hasChildren()) {
                    if (prefix.isEmpty() && 0 == segmentChars) {
                        Optional<? extends TrieNode> child = toNode.getChild(ESCAPE.charValue());
                        assert (child.isPresent());
                        toNode = child.get();
                    } else {
                        toNode = toNode.getChild('\uffff').get();
                    }
                }
                Interval interval = fromNode.intervalTo(toNode);
                Bits segmentData = interval.toBits();
                if (this.verbose) {
                    System.out.println(String.format("Using context \"%s\", encoded \"%s\" (%s chars) as %s -> %s", fromNode.getDebugString(), toNode.getDebugString(fromNode), segmentChars, interval, segmentData));
                }
                out.write(segmentData);
                if (0 == segmentChars) {
                    if (prefix.isEmpty()) {
                        char exotic = text.charAt(0);
                        out.write(exotic);
                        if (this.verbose) {
                            System.out.println(String.format("Writing exotic character %s -> %s", Character.valueOf(exotic), new Bits(exotic, 16)));
                        }
                        text = text.substring(1);
                        continue;
                    }
                    if (toNode.getChar() == '\uffff') {
                        contextStr = prefix.substring(1);
                        continue;
                    }
                    throw new RuntimeException("Cannot encode " + text.substring(0, 1));
                }
                contextStr = contextStr + text.substring(0, segmentChars);
                text = text.substring(segmentChars);
            }
            out.flush();
            Bits bits = new Bits(buffer.toByteArray(), out.getTotalBitsWritten());
            return bits;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getMemorySize() {
        return this.inner.getMemorySize();
    }

    public PPMCodec copy() {
        return new PPMCodec(this.inner.copy());
    }
}

