/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.simiacryptus.util.io.AsyncOutputStream;
import com.simiacryptus.util.io.TeeOutputStream;
import fi.iki.elonen.NanoHTTPD;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class StreamNanoHTTPD
extends NanoHTTPD {
    public final Map<CharSequence, Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response>> customHandlers = new HashMap<CharSequence, Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response>>();
    @Nonnull
    public final TeeOutputStream dataReciever;
    @Nonnull
    private final File file;
    @Nonnull
    private final URI gatewayUri;
    private final String mimeType;
    private final ExecutorService pool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).build());

    public StreamNanoHTTPD(int port, String mimeType, File file) throws IOException {
        super(port);
        this.file = file;
        this.mimeType = mimeType;
        try {
            this.gatewayUri = null == file ? null : new URI(String.format("http://localhost:%s/%s", port, file.getName()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.dataReciever = null == file ? null : new TeeOutputStream((OutputStream)new FileOutputStream(file), true){

            @Override
            public void close() {
                try {
                    Thread.sleep(100L);
                    StreamNanoHTTPD.this.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public StreamNanoHTTPD(int port) throws IOException {
        this(port, null, null);
    }

    public static Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response> asyncHandler(@Nonnull ExecutorService pool, String mimeType, @Nonnull Consumer<OutputStream> logic, boolean async) {
        return session -> {
            PipedInputStream snk = new PipedInputStream();
            Semaphore onComplete = new Semaphore(0);
            pool.submit(() -> {
                try (BufferedOutputStream out = new BufferedOutputStream(new AsyncOutputStream(new PipedOutputStream(snk)));){
                    try {
                        logic.accept(out);
                    }
                    finally {
                        onComplete.release();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            });
            if (!async) {
                try {
                    onComplete.acquire();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return NanoHTTPD.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mimeType, (InputStream)new BufferedInputStream(snk));
        };
    }

    @Nonnull
    public static OutputStream create(int port, @Nonnull File path, String mimeType) throws IOException {
        return new StreamNanoHTTPD((int)port, (String)mimeType, (File)path).init().dataReciever;
    }

    public static Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response> syncHandler(ExecutorService pool, String mimeType, @Nonnull Consumer<OutputStream> logic, boolean async) {
        return session -> {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                logic.accept(out);
                out.flush();
                byte[] bytes = out.toByteArray();
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mimeType, (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length);
                return response;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        };
    }

    public void addAsyncHandler(CharSequence path, String mimeType, @Nonnull Consumer<OutputStream> logic, boolean async) {
        this.addSessionHandler(path, StreamNanoHTTPD.asyncHandler(this.pool, mimeType, logic, async));
    }

    public Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response> addSessionHandler(CharSequence path, Function<NanoHTTPD.IHTTPSession, NanoHTTPD.Response> value) {
        return this.customHandlers.put(path, value);
    }

    public void addSyncHandler(CharSequence path, String mimeType, @Nonnull Consumer<OutputStream> logic, boolean async) {
        this.addSessionHandler(path, StreamNanoHTTPD.syncHandler(this.pool, mimeType, logic, async));
    }

    @Nonnull
    public StreamNanoHTTPD init() throws IOException {
        this.start(30000);
        new Thread(() -> {
            try {
                Thread.sleep(100L);
                if (null != this.gatewayUri) {
                    Desktop.getDesktop().browse(this.gatewayUri);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        return this;
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        File file;
        String requestPath = session.getUri();
        while (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        if (null != this.file && requestPath.equals(this.file.getName())) {
            try {
                NanoHTTPD.Response response = NanoHTTPD.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)this.mimeType, (InputStream)new BufferedInputStream(this.dataReciever.newInputStream()));
                response.setGzipEncoding(false);
                return response;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.customHandlers.containsKey(requestPath)) {
            return this.customHandlers.get(requestPath).apply(session);
        }
        File file2 = file = null == this.file ? null : new File(this.file.getParent(), requestPath);
        if (null != file && file.exists()) {
            try {
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, null, (InputStream)new FileInputStream(file), (long)file.length());
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)"Not Found");
    }

    protected boolean useGzipWhenAccepted(NanoHTTPD.Response r) {
        return false;
    }
}

