/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import com.simiacryptus.util.TableOutput;
import com.simiacryptus.util.Util;
import com.simiacryptus.util.io.NotebookOutput;
import com.simiacryptus.util.lang.CodeUtil;
import com.simiacryptus.util.lang.TimedResult;
import com.simiacryptus.util.lang.UncheckedSupplier;
import com.simiacryptus.util.test.SysOutInterceptor;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlNotebookOutput
implements NotebookOutput {
    private static final Logger log = LoggerFactory.getLogger(HtmlNotebookOutput.class);
    @Nonnull
    public static String DEFAULT_ROOT = "https://github.com/SimiaCryptus/utilities/tree/master/";
    public final File workingDir;
    @Nonnull
    private final PrintStream primaryOut;
    private final int maxOutSize = 8192;
    public String sourceRoot = DEFAULT_ROOT;
    int excerptNumber = 0;

    public HtmlNotebookOutput(File parentDirectory, @Nonnull OutputStream out) {
        this.primaryOut = new PrintStream(out);
        this.workingDir = parentDirectory;
        this.out("<html><head><style>\npre {\n    background-color: lightyellow;\n    margin-left: 20pt;\n    font-family: monospace;\n}\n</style></head><body>", new Object[0]);
    }

    public static HtmlNotebookOutput create(File parentDirectory) throws FileNotFoundException {
        final FileOutputStream out = new FileOutputStream(new File(parentDirectory, "index.html"));
        return new HtmlNotebookOutput(parentDirectory, out){

            @Override
            public void close() throws IOException {
                out.close();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.out("</body></html>", new Object[0]);
        if (null != this.primaryOut) {
            this.primaryOut.close();
        }
    }

    @Override
    @Nonnull
    public <T> T code(@Nonnull UncheckedSupplier<T> fn, int maxLog, int framesNo) {
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            StackTraceElement callingFrame = stackTrace[framesNo];
            String sourceCode = CodeUtil.getInnerText(callingFrame);
            SysOutInterceptor.LoggedResult<TimedResult> result = SysOutInterceptor.withOutput(() -> {
                long priorGcMs = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum();
                long start = System.nanoTime();
                try {
                    Object result1 = null;
                    try {
                        result1 = fn.get();
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    long gcTime = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum() - priorGcMs;
                    return new TimedResult<Object>(result1, System.nanoTime() - start, gcTime);
                }
                catch (Throwable e) {
                    long gcTime = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum() - priorGcMs;
                    return new TimedResult<Throwable>(e, System.nanoTime() - start, gcTime);
                }
            });
            try {
                URI resolved = URI.create(this.sourceRoot).resolve(Util.pathTo(CodeUtil.projectRoot, CodeUtil.findFile(callingFrame)));
                this.out("<p>Code from <a href='%s#L%s'>%s:%s</a> executed in %.2f seconds: <br/>", resolved, callingFrame.getLineNumber(), callingFrame.getFileName(), callingFrame.getLineNumber(), ((TimedResult)result.obj).seconds());
            }
            catch (Exception e) {
                this.out("<p>Code from %s:%s executed in %.2f seconds: <br/>", callingFrame.getFileName(), callingFrame.getLineNumber(), ((TimedResult)result.obj).seconds());
            }
            this.out("<pre>", new Object[0]);
            this.out(sourceCode, new Object[0]);
            this.out("</pre>", new Object[0]);
            if (!result.log.isEmpty()) {
                this.out("Logging: <br/>", new Object[0]);
                this.out("<pre>", new Object[0]);
                this.out(this.summarize(maxLog, result.log), new Object[0]);
                this.out("</pre>", new Object[0]);
            }
            this.out("", new Object[0]);
            Object eval = ((TimedResult)result.obj).result;
            if (null != eval) {
                boolean escape;
                String str;
                this.out("Returns: <br/>", new Object[0]);
                if (eval instanceof Throwable) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ((Throwable)eval).printStackTrace(new PrintStream(out));
                    str = new String(out.toByteArray(), "UTF-8");
                    escape = true;
                } else if (eval instanceof Component) {
                    str = this.image(Util.toImage((Component)eval), "Result");
                    escape = false;
                } else if (eval instanceof BufferedImage) {
                    str = this.image((BufferedImage)eval, "Result");
                    escape = false;
                } else if (eval instanceof TableOutput) {
                    str = ((TableOutput)eval).toHtmlTable();
                    escape = false;
                } else {
                    str = eval.toString();
                    escape = true;
                }
                if (escape) {
                    this.out("<pre>" + this.summarize(maxLog, str) + "</pre>", new Object[0]);
                } else {
                    this.out(this.summarize(maxLog, str), new Object[0]);
                }
                if (escape) {
                    // empty if block
                }
                this.out("\n\n", new Object[0]);
                if (eval instanceof Throwable) {
                    throw new RuntimeException((Throwable)((TimedResult)result.obj).result);
                }
            }
            this.out("</p>", new Object[0]);
            return eval;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public OutputStream file(@Nonnull CharSequence name) {
        try {
            return new FileOutputStream(new File(this.getResourceDir(), name.toString()));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public String file(CharSequence data, CharSequence caption) {
        return this.file(data, (CharSequence)(this.excerptNumber++ + ".txt"), caption);
    }

    @Override
    @Nonnull
    public CharSequence file(byte[] data, @Nonnull CharSequence filename, CharSequence caption) {
        try {
            IOUtils.write((byte[])data, (OutputStream)new FileOutputStream(new File(this.getResourceDir(), filename.toString())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "<a href='etc/" + filename + "'>" + caption + "</a>";
    }

    @Override
    @Nonnull
    public String file(CharSequence data, @Nonnull CharSequence fileName, CharSequence caption) {
        try {
            IOUtils.write((CharSequence)data, (OutputStream)new FileOutputStream(new File(this.getResourceDir(), fileName.toString())), (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "<a href='etc/" + fileName + "'>" + caption + "</a>";
    }

    @Override
    @Nonnull
    public File getResourceDir() {
        File etc = new File(this.workingDir, "etc");
        etc.mkdirs();
        return etc;
    }

    public CharSequence getSourceRoot() {
        return this.sourceRoot;
    }

    @Nonnull
    public HtmlNotebookOutput setSourceRoot(String sourceRoot) {
        this.sourceRoot = sourceRoot;
        return this;
    }

    @Override
    public void h1(CharSequence fmt, Object ... args) {
        this.out("<h1>" + fmt + "</h1>", args);
    }

    @Override
    public void h2(CharSequence fmt, Object ... args) {
        this.out("<h2>" + fmt + "</h2>", args);
    }

    @Override
    public void h3(CharSequence fmt, Object ... args) {
        this.out("<h3>" + fmt + "</h3>", args);
    }

    @Override
    @Nonnull
    public String image(@Nullable BufferedImage rawImage, CharSequence caption) {
        if (null == rawImage) {
            return "";
        }
        new ByteArrayOutputStream();
        String thisImage = UUID.randomUUID().toString().substring(0, 8);
        File file = new File(this.getResourceDir(), "img" + thisImage + ".png");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)rawImage, "png", buffer);
            String pngSrc = Base64.getEncoder().encodeToString(buffer.toByteArray());
            if (pngSrc.length() < 4096) {
                return "<img src='data:image/png;base64," + pngSrc + "' alt='" + caption + "'/>";
            }
            BufferedImage stdImage = Util.resize(rawImage);
            if (stdImage != rawImage) {
                ImageIO.write((RenderedImage)rawImage, "png", new File(this.getResourceDir(), "raw" + thisImage + ".png"));
            }
            ImageIO.write((RenderedImage)stdImage, "png", file);
            return "<img src='etc/" + file.getName() + "' alt='" + caption + "'/>";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CharSequence link(@Nonnull File file, CharSequence text) {
        String path = null;
        try {
            path = this.workingDir.getCanonicalFile().toPath().relativize(file.getCanonicalFile().toPath()).normalize().toString().replaceAll("\\\\", "/");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return String.format("<a href=\"%s\">%s</a>", path, text);
    }

    @Override
    public void out(@Nonnull String fmt, Object ... args) {
        String msg = 0 == args.length ? fmt : String.format(fmt, args);
        this.primaryOut.println(msg);
        this.primaryOut.flush();
        log.info(msg);
    }

    @Override
    public void p(CharSequence fmt, Object ... args) {
        this.out("<p>" + fmt + "</p>", args);
    }

    @Override
    @Nullable
    public CharSequence getFrontMatterProperty(CharSequence key) {
        return null;
    }

    @Override
    @Nonnull
    public CharSequence getName() {
        return "www";
    }

    @Nonnull
    public String summarize(int maxLog, @Nonnull String string) {
        if (string.length() > maxLog * 2) {
            String left = string.substring(0, maxLog);
            String right = string.substring(string.length() - maxLog);
            String link = String.format(this.file(string, "\n...skipping %s bytes...\n"), string.length() - 2 * maxLog);
            return left.toString() + link + right;
        }
        return string;
    }

    @Override
    public int getMaxOutSize() {
        return 8192;
    }
}

