/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JsonUtil {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static double[] getDoubleArray(@Nonnull JsonArray array) {
        return IntStream.range(0, array.size()).mapToDouble(i -> array.get(i).getAsDouble()).toArray();
    }

    @Nullable
    public static int[] getIntArray(@Nullable JsonArray array) {
        if (null == array) {
            return null;
        }
        return IntStream.range(0, array.size()).map(i -> array.get(i).getAsInt()).toArray();
    }

    @Nonnull
    public static JsonArray getJson(@Nonnull double[] kernelDims) {
        JsonArray array = new JsonArray();
        for (double k : kernelDims) {
            array.add((JsonElement)new JsonPrimitive((Number)k));
        }
        return array;
    }

    @Nonnull
    public static JsonArray getJson(@Nonnull int[] kernelDims) {
        JsonArray array = new JsonArray();
        for (int k : kernelDims) {
            array.add((JsonElement)new JsonPrimitive((Number)k));
        }
        return array;
    }

    public static CharSequence toJson(Object obj) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            JsonUtil.writeJson(outputStream, obj);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new String(outputStream.toByteArray(), Charset.forName("UTF-8"));
    }

    public static void writeJson(@Nonnull OutputStream out, Object obj) throws IOException {
        ObjectMapper mapper = new ObjectMapper().enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL).enable(SerializationFeature.INDENT_OUTPUT);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        mapper.writeValue((OutputStream)buffer, obj);
        out.write(buffer.toByteArray());
    }
}

