/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import com.simiacryptus.util.TableOutput;
import com.simiacryptus.util.Util;
import com.simiacryptus.util.io.NotebookOutput;
import com.simiacryptus.util.lang.CodeUtil;
import com.simiacryptus.util.lang.TimedResult;
import com.simiacryptus.util.lang.UncheckedSupplier;
import com.simiacryptus.util.test.SysOutInterceptor;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownNotebookOutput
implements NotebookOutput {
    static final Logger log = LoggerFactory.getLogger(MarkdownNotebookOutput.class);
    public static int MAX_OUTPUT = 4096;
    private static int excerptNumber = 0;
    private static int imageNumber = 0;
    @Nonnull
    private final File fileName;
    private final String name;
    @Nonnull
    private final PrintStream primaryOut;
    private final List<CharSequence> buffer = new ArrayList<CharSequence>();
    private final Map<CharSequence, CharSequence> frontMatter = new HashMap<CharSequence, CharSequence>();
    @Nonnull
    public List<CharSequence> toc = new ArrayList<CharSequence>();
    int anchor = 0;
    @Nullable
    private String absoluteUrl = null;

    public MarkdownNotebookOutput(@Nonnull File fileName, String name) throws FileNotFoundException {
        this.name = name;
        this.primaryOut = new PrintStream(new FileOutputStream(fileName));
        this.fileName = fileName;
    }

    @Nonnull
    public static MarkdownNotebookOutput get(@Nonnull Class<?> sourceClass, @Nullable CharSequence absoluteUrl, CharSequence ... suffix) {
        try {
            StackTraceElement callingFrame = Thread.currentThread().getStackTrace()[2];
            String methodName = callingFrame.getMethodName();
            String className = sourceClass.getCanonicalName();
            File path = new File(Util.mkString(File.separator, "reports", className.replaceAll("\\.", "/").replaceAll("\\$", "/")));
            for (int i = 0; i < suffix.length - 1; ++i) {
                path = new File(path, suffix[i].toString());
            }
            String testName = suffix.length == 0 ? String.valueOf(methodName) : suffix[suffix.length - 1].toString();
            path = new File(path, testName + ".md");
            path.getParentFile().mkdirs();
            MarkdownNotebookOutput notebookOutput = new MarkdownNotebookOutput(path, testName);
            if (null != absoluteUrl) {
                try {
                    String url = new URI(absoluteUrl + "/" + path.toPath().toString().replaceAll("\\\\", "/")).normalize().toString();
                    notebookOutput.setAbsoluteUrl(url);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            return notebookOutput;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static MarkdownNotebookOutput get() {
        try {
            StackTraceElement callingFrame = Thread.currentThread().getStackTrace()[2];
            String className = callingFrame.getClassName();
            String methodName = callingFrame.getMethodName();
            String fileName = methodName + ".md";
            File path = new File(Util.mkString(File.separator, "reports", className.replaceAll("\\.", "/").replaceAll("\\$", "/")));
            path = new File(path, fileName);
            path.getParentFile().mkdirs();
            return new MarkdownNotebookOutput(path, methodName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static MarkdownNotebookOutput get(Object source) {
        try {
            StackTraceElement callingFrame = Thread.currentThread().getStackTrace()[2];
            String className = null == source ? callingFrame.getClassName() : source.getClass().getCanonicalName();
            String methodName = callingFrame.getMethodName();
            String fileName = methodName + ".md";
            File path = new File(Util.mkString(File.separator, "reports", className.replaceAll("\\.", "/").replaceAll("\\$", "/"), fileName));
            path.getParentFile().mkdirs();
            return new MarkdownNotebookOutput(path, methodName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (null != this.primaryOut) {
            this.primaryOut.close();
            try (PrintWriter out = new PrintWriter(new FileOutputStream(this.fileName));){
                if (!this.frontMatter.isEmpty()) {
                    out.println("---");
                    this.frontMatter.forEach((key, value) -> {
                        String escaped = StringEscapeUtils.escapeJson((String)String.valueOf(value)).replaceAll("\n", " ").replaceAll(":", "&#58;").replaceAll("\\{", "\\{").replaceAll("\\}", "\\}");
                        out.println(String.format("%s: %s", key, escaped));
                    });
                    out.println("---");
                }
                this.toc.forEach(out::println);
                out.print("\n\n");
                this.buffer.forEach(out::println);
            }
        }
    }

    @Override
    public void setFrontMatterProperty(CharSequence key, CharSequence value) {
        this.frontMatter.put(key, value);
    }

    @Override
    public CharSequence getFrontMatterProperty(CharSequence key) {
        return this.frontMatter.get(key);
    }

    @Override
    public CharSequence getName() {
        return this.name;
    }

    public CharSequence anchor(CharSequence anchorId) {
        return String.format("<a id=\"%s\"></a>", anchorId);
    }

    public CharSequence anchorId() {
        return String.format("p-%d", this.anchor++);
    }

    @Override
    public <T> T code(@Nonnull UncheckedSupplier<T> fn, int maxLog, int framesNo) {
        try {
            StackTraceElement callingFrame = Thread.currentThread().getStackTrace()[framesNo];
            String sourceCode = CodeUtil.getInnerText(callingFrame);
            SysOutInterceptor.LoggedResult<TimedResult> result = SysOutInterceptor.withOutput(() -> {
                long priorGcMs = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum();
                long start = System.nanoTime();
                try {
                    Object result1 = null;
                    try {
                        result1 = fn.get();
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    long gcTime = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum() - priorGcMs;
                    return new TimedResult<Object>(result1, System.nanoTime() - start, gcTime);
                }
                catch (Throwable e) {
                    long gcTime = ManagementFactory.getGarbageCollectorMXBeans().stream().mapToLong(x -> x.getCollectionTime()).sum() - priorGcMs;
                    return new TimedResult<Throwable>(e, System.nanoTime() - start, gcTime);
                }
            });
            this.out(this.anchor(this.anchorId()) + "Code from [%s:%s](%s#L%s) executed in %.2f seconds (%.3f gc): ", callingFrame.getFileName(), callingFrame.getLineNumber(), this.linkTo(CodeUtil.findFile(callingFrame)), callingFrame.getLineNumber(), ((TimedResult)result.obj).seconds(), ((TimedResult)result.obj).gc_seconds());
            String text = sourceCode.replaceAll("\n", "\n  ");
            this.out("```java", new Object[0]);
            this.out("  " + text, new Object[0]);
            this.out("```", new Object[0]);
            if (!result.log.isEmpty()) {
                String summary = this.summarize(result.log, maxLog).replaceAll("\n", "\n    ").replaceAll("    ~", "");
                this.out(this.anchor(this.anchorId()) + "Logging: ", new Object[0]);
                this.out("```", new Object[0]);
                this.out("    " + summary, new Object[0]);
                this.out("```", new Object[0]);
            }
            this.out("", new Object[0]);
            Object eval = ((TimedResult)result.obj).result;
            if (null != eval) {
                String fmt;
                boolean escape;
                String str;
                this.out(this.anchor(this.anchorId()) + "Returns: \n", new Object[0]);
                if (eval instanceof Throwable) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ((Throwable)eval).printStackTrace(new PrintStream(out));
                    str = new String(out.toByteArray(), "UTF-8");
                    escape = true;
                } else if (eval instanceof Component) {
                    str = this.image(Util.toImage((Component)eval), "Result");
                    escape = false;
                } else if (eval instanceof BufferedImage) {
                    str = this.image((BufferedImage)eval, "Result");
                    escape = false;
                } else if (eval instanceof TableOutput) {
                    str = ((TableOutput)eval).toTextTable();
                    escape = false;
                } else {
                    str = eval.toString();
                    escape = true;
                }
                String string = fmt = escape ? "    " + this.summarize(str, maxLog).replaceAll("\n", "\n    ").replaceAll("    ~", "") : str;
                if (escape) {
                    this.out("```", new Object[0]);
                    this.out(fmt, new Object[0]);
                    this.out("```", new Object[0]);
                } else {
                    this.out(fmt, new Object[0]);
                }
                this.out("\n\n", new Object[0]);
                if (eval instanceof RuntimeException) {
                    throw (RuntimeException)((TimedResult)result.obj).result;
                }
                if (eval instanceof Throwable) {
                    throw new RuntimeException((Throwable)((TimedResult)result.obj).result);
                }
            }
            return eval;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public OutputStream file(@Nonnull CharSequence name) {
        try {
            return new FileOutputStream(new File(this.getResourceDir(), name.toString()));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public String file(CharSequence data, CharSequence caption) {
        return this.file(data, (CharSequence)(++excerptNumber + ".txt"), caption);
    }

    @Override
    @Nonnull
    public CharSequence file(@Nonnull byte[] data, @Nonnull CharSequence filename, CharSequence caption) {
        return this.file(new String(data, Charset.forName("UTF-8")), filename, caption);
    }

    @Override
    @Nonnull
    public String file(@Nullable CharSequence data, @Nonnull CharSequence fileName, CharSequence caption) {
        try {
            if (null != data) {
                IOUtils.write((CharSequence)data, (OutputStream)new FileOutputStream(new File(this.getResourceDir(), fileName.toString())), (Charset)Charset.forName("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "[" + caption + "](etc/" + fileName + ")";
    }

    @Nullable
    public String getAbsoluteUrl() {
        return this.absoluteUrl;
    }

    @Nonnull
    public MarkdownNotebookOutput setAbsoluteUrl(String absoluteUrl) {
        this.absoluteUrl = absoluteUrl;
        return this;
    }

    @Override
    @Nonnull
    public File getResourceDir() {
        File etc = new File(this.fileName.getParentFile(), "etc");
        etc.mkdirs();
        return etc;
    }

    @Override
    public void h1(@Nonnull CharSequence fmt, Object ... args) {
        CharSequence anchorId = this.anchorId();
        String msg = this.format(fmt, args);
        this.toc.add(String.format("1. [%s](#%s)", msg, anchorId));
        this.out("# " + this.anchor(anchorId) + msg, new Object[0]);
    }

    @Override
    public void h2(@Nonnull CharSequence fmt, Object ... args) {
        CharSequence anchorId = this.anchorId();
        String msg = this.format(fmt, args);
        this.toc.add(String.format("   1. [%s](#%s)", msg, anchorId));
        this.out("## " + this.anchor(anchorId) + fmt, args);
    }

    @Override
    public void h3(@Nonnull CharSequence fmt, Object ... args) {
        CharSequence anchorId = this.anchorId();
        String msg = this.format(fmt, args);
        this.toc.add(String.format("      1. [%s](#%s)", msg, anchorId));
        this.out("### " + this.anchor(anchorId) + fmt, args);
    }

    @Override
    @Nonnull
    public String image(@Nullable BufferedImage rawImage, CharSequence caption) {
        if (null == rawImage) {
            return "";
        }
        new ByteArrayOutputStream();
        int thisImage = ++imageNumber;
        String fileName = this.name + "." + thisImage + ".png";
        File file = new File(this.getResourceDir(), fileName);
        BufferedImage stdImage = Util.resize(rawImage);
        try {
            if (stdImage != rawImage) {
                String rawName = this.name + "_raw." + thisImage + ".png";
                ImageIO.write((RenderedImage)rawImage, "png", new File(this.getResourceDir(), rawName));
            }
            ImageIO.write((RenderedImage)stdImage, "png", file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.anchor(this.anchorId()) + "![" + caption + "](etc/" + file.getName() + ")";
    }

    @Override
    @Nonnull
    public CharSequence link(@Nonnull File file, CharSequence text) {
        try {
            return "[" + text + "](" + this.codeFile(file) + ")";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CharSequence codeFile(@Nonnull File file) throws IOException {
        Path path = this.pathToCodeFile(file);
        if (null != this.getAbsoluteUrl()) {
            try {
                return new URI(this.getAbsoluteUrl()).resolve(path.normalize().toString().replaceAll("\\\\", "/")).normalize().toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return path.normalize().toString().replaceAll("\\\\", "/");
    }

    public Path pathToCodeFile(@Nonnull File file) throws IOException {
        return this.fileName.getCanonicalFile().toPath().relativize(file.getCanonicalFile().toPath());
    }

    public CharSequence linkTo(@Nonnull File file) throws IOException {
        return this.codeFile(file);
    }

    @Override
    public void out(@Nonnull String fmt, Object ... args) {
        String msg = this.format(fmt, args);
        this.buffer.add(msg);
        this.primaryOut.println(msg);
        log.info(msg);
    }

    @Nonnull
    public String format(@Nonnull CharSequence fmt, Object ... args) {
        return 0 == args.length ? fmt.toString() : String.format(fmt.toString(), args);
    }

    @Override
    public void p(CharSequence fmt, Object ... args) {
        this.out(this.anchor(this.anchorId()).toString() + fmt + "\n", args);
    }

    @Nonnull
    public String summarize(@Nonnull String logSrc, int maxLog) {
        if (logSrc.length() > maxLog * 2) {
            String prefix = logSrc.substring(0, maxLog);
            logSrc = prefix + String.format((prefix.endsWith("\n") ? "" : "\n") + "~```\n~..." + this.file(logSrc, "skipping %s bytes") + "...\n~```\n", logSrc.length() - 2 * maxLog) + logSrc.substring(logSrc.length() - maxLog);
        }
        return logSrc;
    }

    @Override
    public int getMaxOutSize() {
        return MAX_OUTPUT;
    }
}

