/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.lang;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public abstract class ResourcePool<T> {
    @Nonnull
    private final HashSet<T> all;
    private final ThreadLocal<T> currentValue = new ThreadLocal();
    private final int maxItems;
    private final LinkedBlockingQueue<T> pool = new LinkedBlockingQueue();

    public ResourcePool(int maxItems) {
        this.maxItems = maxItems;
        this.all = new HashSet(this.maxItems);
    }

    public abstract T create();

    public T get() {
        return (T)this.get(x -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(Predicate<T> filter) {
        Object poll;
        ArrayList<T> sampled = new ArrayList<T>();
        try {
            poll = this.pool.poll();
            while (null != poll) {
                if (filter.test(poll)) {
                    T t = poll;
                    return t;
                }
                sampled.add(poll);
            }
        }
        finally {
            this.pool.addAll(sampled);
        }
        poll = this.all;
        synchronized (poll) {
            if (this.all.size() < this.maxItems) {
                T poll2 = this.create();
                this.all.add(poll2);
                return poll2;
            }
        }
        try {
            return this.pool.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int size() {
        return this.all.size();
    }

    public <U> U apply(@Nonnull Function<T, U> f) {
        return this.apply(f, (T x) -> true);
    }

    public void apply(@Nonnull Consumer<T> f) {
        this.apply(f, (T x) -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> U apply(@Nonnull Function<T, U> f, Predicate<T> filter) {
        T prior = this.currentValue.get();
        if (null != prior) {
            return f.apply(prior);
        }
        T poll = this.get(filter);
        try {
            this.currentValue.set(poll);
            U u = f.apply(poll);
            return u;
        }
        finally {
            this.pool.add(poll);
            this.currentValue.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(@Nonnull Consumer<T> f, Predicate<T> filter) {
        T prior = this.currentValue.get();
        if (null != prior) {
            f.accept(prior);
        } else {
            T poll = this.get(filter);
            try {
                this.currentValue.set(poll);
                f.accept(poll);
            }
            finally {
                this.pool.add(poll);
                this.currentValue.remove();
            }
        }
    }
}

