/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.test;

import com.simiacryptus.util.Util;
import com.simiacryptus.util.io.AsyncListIterator;
import com.simiacryptus.util.test.TestDocument;
import com.simiacryptus.util.test.WikiArticle;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.compress.utils.IOUtils;

public class Shakespeare
extends TestDocument {
    private static final ArrayList<Shakespeare> queue = new ArrayList();
    public static String url = "http://www.gutenberg.org/cache/epub/100/pg100.txt";
    public static String file = "Shakespeare.txt";
    private static volatile Thread thread;

    public Shakespeare(String text) {
        super(text, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clear() throws InterruptedException {
        if (thread == null) return;
        Class<WikiArticle> clazz = WikiArticle.class;
        synchronized (WikiArticle.class) {
            if (thread == null) return;
            thread.interrupt();
            thread.join();
            thread = null;
            queue.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Stream<Shakespeare> load() {
        if (thread == null) {
            Class<WikiArticle> clazz = WikiArticle.class;
            // MONITORENTER : com.simiacryptus.util.test.WikiArticle.class
            if (thread == null) {
                thread = new Thread(Shakespeare::read);
                thread.setDaemon(true);
                thread.start();
            }
            // MONITOREXIT : clazz
        }
        AsyncListIterator<Shakespeare> iterator = new AsyncListIterator<Shakespeare>(queue, thread);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1), false).filter(x -> x != null);
    }

    private static void read() {
        try {
            InputStream in = Util.cache(url, file);
            String txt = new String(IOUtils.toByteArray((InputStream)in), "UTF-8").replaceAll("\r", "");
            for (String paragraph : txt.split("\n\\s*\n")) {
                queue.add(new Shakespeare(paragraph));
            }
        }
        catch (IOException in) {
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof InterruptedException)) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

