/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common;

import com.stackify.api.EnvironmentDetail;

public class ApiConfiguration {
    private static final String DEFAULT_API_URL = "https://api.stackify.com";
    private final String apiUrl;
    private final String apiKey;
    private final String application;
    private final String environment;
    private final EnvironmentDetail envDetail;
    private final Boolean skipJson;
    private final Boolean allowComDotStackify;

    public String getApiUrl() {
        return this.apiUrl != null ? this.apiUrl : DEFAULT_API_URL;
    }

    ApiConfiguration(String apiUrl, String apiKey, String application, String environment, EnvironmentDetail envDetail, Boolean skipJson, Boolean allowComDotStackify) {
        this.apiUrl = apiUrl;
        this.apiKey = apiKey;
        this.application = application;
        this.environment = environment;
        this.envDetail = envDetail;
        this.skipJson = skipJson;
        this.allowComDotStackify = allowComDotStackify;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().apiUrl(this.apiUrl).apiKey(this.apiKey).application(this.application).environment(this.environment).envDetail(this.envDetail).skipJson(this.skipJson).allowComDotStackify(this.allowComDotStackify);
    }

    public String toString() {
        return "ApiConfiguration(apiUrl=" + this.getApiUrl() + ", apiKey=" + this.getApiKey() + ", application=" + this.getApplication() + ", environment=" + this.getEnvironment() + ", envDetail=" + this.getEnvDetail() + ", skipJson=" + this.getSkipJson() + ", allowComDotStackify=" + this.getAllowComDotStackify() + ")";
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApplication() {
        return this.application;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public EnvironmentDetail getEnvDetail() {
        return this.envDetail;
    }

    public Boolean getSkipJson() {
        return this.skipJson;
    }

    public Boolean getAllowComDotStackify() {
        return this.allowComDotStackify;
    }

    public static class Builder {
        private String apiUrl;
        private String apiKey;
        private String application;
        private String environment;
        private EnvironmentDetail envDetail;
        private Boolean skipJson;
        private Boolean allowComDotStackify;

        Builder() {
        }

        public Builder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder application(String application) {
            this.application = application;
            return this;
        }

        public Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder envDetail(EnvironmentDetail envDetail) {
            this.envDetail = envDetail;
            return this;
        }

        public Builder skipJson(Boolean skipJson) {
            this.skipJson = skipJson;
            return this;
        }

        public Builder allowComDotStackify(Boolean allowComDotStackify) {
            this.allowComDotStackify = allowComDotStackify;
            return this;
        }

        public ApiConfiguration build() {
            return new ApiConfiguration(this.apiUrl, this.apiKey, this.application, this.environment, this.envDetail, this.skipJson, this.allowComDotStackify);
        }

        public String toString() {
            return "ApiConfiguration.Builder(apiUrl=" + this.apiUrl + ", apiKey=" + this.apiKey + ", application=" + this.application + ", environment=" + this.environment + ", envDetail=" + this.envDetail + ", skipJson=" + this.skipJson + ", allowComDotStackify=" + this.allowComDotStackify + ")";
        }
    }
}

