/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.net;

import com.stackmob.sdk.callback.StackMobRedirectedCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.net.HttpRedirectHelper;
import com.stackmob.sdk.net.NoopResponseHandler;
import com.stackmob.sdk.util.Pair;
import java.net.URI;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class HttpHelper {
    private static final int CONN_TIMEOUT = 20000;
    private static final String DEFAULT_CONTENT_TYPE_FMT = "application/vnd.stackmob+json; version=%d";
    private static String DEFAULT_CONTENT_TYPE;
    private static DefaultHttpClient mHttpClient;
    private static OAuthConsumer mConsumer;

    public static String doGet(URI uri, String sessionKey, String sessionSecret, Integer apiVersionNum, StackMobRedirectedCallback cb) throws StackMobException {
        return HttpHelper.doRequest((HttpRequestBase)HttpHelper.setHeaders(new HttpGet(uri), apiVersionNum), sessionKey, sessionSecret, cb);
    }

    public static String doGet(URI uri, String sessionKey, String sessionSecret, String appName, Integer apiVersionNum, StackMobRedirectedCallback cb) throws StackMobException {
        return HttpHelper.doRequest((HttpRequestBase)HttpHelper.setHeaders(new HttpGet(uri), appName, apiVersionNum), sessionKey, sessionSecret, cb);
    }

    public static String doPost(URI uri, HttpEntity entity, String sessionKey, String sessionSecret, Integer apiVersionNum, StackMobRedirectedCallback cb) throws StackMobException {
        return HttpHelper.doRequest((HttpRequestBase)HttpHelper.setHeaders(new HttpPost(uri), apiVersionNum, entity), sessionKey, sessionSecret, cb);
    }

    public static String doPost(URI uri, HttpEntity entity, String sessionKey, String sessionSecret, String appName, Integer apiVersionNum, StackMobRedirectedCallback cb) throws StackMobException {
        return HttpHelper.doRequest((HttpRequestBase)HttpHelper.setHeaders(new HttpPost(uri), appName, apiVersionNum, entity), sessionKey, sessionSecret, cb);
    }

    public static String doPut(URI uri, HttpEntity entity, String sessionKey, String sessionSecret, Integer apiVersionNum, StackMobRedirectedCallback cb) throws StackMobException {
        return HttpHelper.doRequest((HttpRequestBase)HttpHelper.setHeaders(new HttpPut(uri), apiVersionNum, entity), sessionKey, sessionSecret, cb);
    }

    public static String doPut(URI uri, HttpEntity entity, String sessionKey, String sessionSecret, String appName, Integer apiVersionNum, StackMobRedirectedCallback cb) throws StackMobException {
        return HttpHelper.doRequest((HttpRequestBase)HttpHelper.setHeaders(new HttpPut(uri), appName, apiVersionNum), sessionKey, sessionSecret, cb);
    }

    public static String doDelete(URI uri, String sessionKey, String sessionSecret, Integer apiVersionNum, StackMobRedirectedCallback cb) throws StackMobException {
        return HttpHelper.doRequest((HttpRequestBase)HttpHelper.setHeaders(new HttpDelete(uri), apiVersionNum), sessionKey, sessionSecret, cb);
    }

    public static String doDelete(URI uri, String sessionKey, String sessionSecret, String appName, Integer apiVersionNum, StackMobRedirectedCallback cb) throws StackMobException {
        return HttpHelper.doRequest((HttpRequestBase)HttpHelper.setHeaders(new HttpDelete(uri), appName, apiVersionNum), sessionKey, sessionSecret, cb);
    }

    private static DefaultHttpClient setupHttpClient(String sessionKey, String sessionSecret, StackMobRedirectedCallback redirCB) {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpHelper.setConnectionParams((HttpParams)httpParams);
        SchemeRegistry schemeRegistry = HttpHelper.registerFactories();
        ThreadSafeClientConnManager clientConnectionManager = new ThreadSafeClientConnManager((HttpParams)httpParams, schemeRegistry);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)clientConnectionManager, (HttpParams)httpParams);
        mConsumer = new CommonsHttpOAuthConsumer(sessionKey, sessionSecret);
        return client;
    }

    public static void setVersion(int version) {
        DEFAULT_CONTENT_TYPE = String.format(DEFAULT_CONTENT_TYPE_FMT, version);
    }

    private static synchronized void ensureHttpClient(String sessionKey, String sessionSecret, StackMobRedirectedCallback redirCB) {
        if (mHttpClient == null) {
            mHttpClient = HttpHelper.setupHttpClient(sessionKey, sessionSecret, redirCB);
        }
    }

    private static <T extends HttpRequestBase> T setHeaders(T req, String userAgent) {
        req.setHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        req.setHeader("Accept", DEFAULT_CONTENT_TYPE);
        req.setHeader("User-Agent", userAgent);
        return req;
    }

    private static <T extends HttpRequestBase> T setHeaders(T req, Integer apiVersionNum) {
        return HttpHelper.setHeaders(req, "Stackmob Java Client; " + apiVersionNum);
    }

    private static <T extends HttpEntityEnclosingRequestBase> T setHeaders(T req, String appName, Integer apiVersionNum, HttpEntity entity) {
        T request = HttpHelper.setHeaders(req, appName, apiVersionNum);
        if (entity != null) {
            request.setEntity(entity);
        }
        return req;
    }

    private static <T extends HttpEntityEnclosingRequestBase> T setHeaders(T req, Integer apiVersionNum, HttpEntity entity) {
        T request = HttpHelper.setHeaders(req, apiVersionNum);
        if (entity != null) {
            request.setEntity(entity);
        }
        return req;
    }

    private static <T extends HttpRequestBase> T setHeaders(T req, String appName, Integer apiVersionNum) {
        return HttpHelper.setHeaders(req, "Stackmob Java Client; " + apiVersionNum + "/" + appName);
    }

    private static String doRequest(HttpRequestBase req, String sessionKey, String sessionSecret, StackMobRedirectedCallback cb) throws StackMobException {
        HttpHelper.ensureHttpClient(sessionKey, sessionSecret, cb);
        try {
            mConsumer.sign((Object)req);
            Pair responsePair = (Pair)mHttpClient.execute((HttpUriRequest)req, (ResponseHandler)new NoopResponseHandler());
            HttpResponse response = (HttpResponse)responsePair.getFirst();
            if (HttpRedirectHelper.isRedirected(response)) {
                HttpRequestBase oldReq = req;
                HttpRequestBase newReq = HttpRedirectHelper.getRedirect(req, response);
                cb.redirected((HttpRequest)oldReq, response, (HttpRequest)newReq);
                return HttpHelper.doRequest(newReq, sessionKey, sessionSecret, cb);
            }
            return (String)responsePair.getSecond();
        }
        catch (Throwable e) {
            throw new StackMobException(e.getMessage());
        }
    }

    private static SchemeRegistry registerFactories() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        SSLSocketFactory sslFactory = SSLSocketFactory.getSocketFactory();
        sslFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        schemeRegistry.register(new Scheme("https", (SocketFactory)sslFactory, 443));
        return schemeRegistry;
    }

    private static void setConnectionParams(HttpParams httpParams) {
        HttpProtocolParams.setVersion((HttpParams)httpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)httpParams, (String)"UTF-8");
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)20000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)20000);
    }
}

