/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpRequestBase;

public class HttpRedirectHelper {
    public static final int RedirectStatusCode = 302;

    public static HttpRequestBase getRedirect(HttpRequestBase oldRequest, HttpResponse response) throws ProtocolException, URISyntaxException {
        if (!HttpRedirectHelper.isRedirected(response)) {
            return oldRequest;
        }
        List<Header> newLocHeaders = Arrays.asList(response.getHeaders("Location"));
        if (newLocHeaders.size() < 1) {
            throw new ProtocolException("302 given for redirect, but no location given");
        }
        oldRequest.setURI(new URI(newLocHeaders.get(0).getValue()));
        return oldRequest;
    }

    public static boolean isRedirected(HttpResponse response) {
        return response.getStatusLine().getStatusCode() == 302;
    }
}

