/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.stackmob.sdk.api.StackMobQueryWithField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StackMobQuery {
    private String objectName;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> args = new HashMap<String, String>();
    private static final String RangeHeader = "Range";
    private static final String ExpandHeader = "X-StackMob-Expand";
    private static final String OrderByHeader = "X-StackMob-OrderBy";

    public StackMobQuery(String objectName) {
        this.objectName = objectName;
    }

    public static StackMobQuery objects(String objectName) {
        return new StackMobQuery(objectName);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getArguments() {
        return this.args;
    }

    public StackMobQueryWithField field(String field) {
        return new StackMobQueryWithField(field, this);
    }

    public StackMobQuery fieldIsIn(String field, List<String> values) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String val : values) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            builder.append(val);
        }
        this.putInMap(field, Operator.IN, builder.toString());
        return this;
    }

    public StackMobQuery fieldIsLessThan(String field, String val) {
        return this.putInMap(field, Operator.LT, val);
    }

    public StackMobQuery fieldIslessThanOrEqualTo(String field, String val) {
        return this.putInMap(field, Operator.LTE, val);
    }

    public StackMobQuery fieldIsGreaterThan(String field, String val) {
        return this.putInMap(field, Operator.GT, val);
    }

    public StackMobQuery fieldIsGreaterThanOrEqualTo(String field, String val) {
        return this.putInMap(field, Operator.GTE, val);
    }

    public StackMobQuery fieldIsEqualTo(String field, String val) {
        this.args.put(field, val);
        return this;
    }

    public StackMobQuery fieldIsOrderedBy(String field, Ordering ordering) {
        String buf = this.headers.get(OrderByHeader);
        buf = buf != null ? buf + "," : "";
        buf = buf + field + ":" + ordering.toString();
        this.headers.put(OrderByHeader, buf);
        return this;
    }

    public StackMobQuery expandDepthIs(Integer i) {
        this.headers.put(ExpandHeader, i.toString());
        return this;
    }

    public StackMobQuery isInRange(Integer start, Integer end) {
        this.headers.put(RangeHeader, "objects=" + start.toString() + "-" + end.toString());
        return this;
    }

    public StackMobQuery isInRange(Integer start) {
        this.headers.put(RangeHeader, "objects=" + start.toString() + "-");
        return this;
    }

    private StackMobQuery putInMap(String field, Operator operator, String value) {
        this.args.put(field + operator.getOperatorForURL(), value);
        return this;
    }

    private StackMobQuery putInMap(String field, Operator operator, int value) {
        this.putInMap(field, operator, Integer.toString(value));
        return this;
    }

    public static enum Operator {
        LT("lt"),
        GT("gt"),
        LTE("lte"),
        GTE("gte"),
        IN("in");

        private String operator;

        private Operator(String operator) {
            this.operator = operator;
        }

        public String getOperatorForURL() {
            return "[" + this.operator + "]";
        }
    }

    public static enum Ordering {
        DESCENDING("desc"),
        ASCENDING("asc");

        private String name;

        private Ordering(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

