/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.stackmob.sdk.api.StackMob;
import com.stackmob.sdk.api.StackMobQuery;
import com.stackmob.sdk.callback.StackMobCallback;
import com.stackmob.sdk.callback.StackMobIntermediaryCallback;
import com.stackmob.sdk.callback.StackMobNoopCallback;
import com.stackmob.sdk.callback.StackMobQueryCallback;
import com.stackmob.sdk.callback.StackMobRawCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.model.StackMobCounter;
import com.stackmob.sdk.model.StackMobModelQuery;
import com.stackmob.sdk.util.Pair;
import com.stackmob.sdk.util.RelationMapping;
import com.stackmob.sdk.util.SerializationMetadata;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class StackMobModel {
    private transient String id;
    private transient Class<? extends StackMobModel> actualClass;
    private transient String schemaName;
    private transient boolean hasData;
    private static final Gson gson = StackMobModel.getGson();

    public static <T extends StackMobModel> void query(Class<T> theClass, StackMobQuery q, StackMobQueryCallback<T> callback) {
        StackMobModelQuery<T> query = new StackMobModelQuery<T>(theClass);
        q.setObjectName(theClass.getSimpleName().toLowerCase());
        query.query = q;
        query.send(callback);
    }

    private static Gson getGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateAsNumberTypeAdapter());
        return gsonBuilder.create();
    }

    public StackMobModel(String id, Class<? extends StackMobModel> actualClass) {
        this(actualClass);
        this.id = id;
    }

    public StackMobModel(Class<? extends StackMobModel> actualClass) {
        this.actualClass = actualClass;
        this.schemaName = actualClass.getSimpleName().toLowerCase();
        StackMobModel.ensureValidModelName(this.schemaName);
        SerializationMetadata.ensureMetadata(actualClass);
    }

    private void ensureValidFieldName(String name) {
        if (name.equalsIgnoreCase(this.getIDFieldName())) {
            throw new IllegalStateException(String.format("Don't create a field called %s. It's your object's id and is treated specially. Use setID and getID instead.", this.getIDFieldName()));
        }
        StackMobModel.ensureValidName(name, "field");
    }

    private static void ensureValidModelName(String name) {
        if (name.contains("_")) {
            throw new IllegalStateException("Model names may not contain underscore");
        }
        StackMobModel.ensureValidName(name, "model");
    }

    private static void ensureValidName(String name, String thing) {
        if (name.matches(".*(\\W).*") || name.length() > 25 || name.length() < 3) {
            throw new IllegalStateException(String.format("Invalid name for a %s: %s. Must be 3-25 alphanumeric characters", thing, name));
        }
    }

    private SerializationMetadata getMetadata(String fieldName) {
        return SerializationMetadata.getSerializationMetadata(this.actualClass, fieldName);
    }

    private String getFieldName(String jsonName) {
        return SerializationMetadata.getFieldNameFromJsonName(this.actualClass, jsonName);
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    protected void setActualClass(Class<? extends StackMobModel> actualClass) {
        this.actualClass = actualClass;
    }

    protected String getSchemaName() {
        return this.schemaName;
    }

    public String getIDFieldName() {
        return this.schemaName + "_id";
    }

    public boolean hasData() {
        return this.hasData;
    }

    protected void fillFieldFromJson(String jsonName, JsonElement json) throws StackMobException {
        try {
            if (jsonName.equals(this.getIDFieldName())) {
                this.setID(json.getAsJsonPrimitive().getAsString());
            } else {
                String fieldName = this.getFieldName(jsonName);
                if (fieldName != null) {
                    Field field = this.getField(fieldName);
                    field.setAccessible(true);
                    if (this.getMetadata(fieldName) == SerializationMetadata.MODEL) {
                        StackMobModel relatedModel = (StackMobModel)field.get(this);
                        if (relatedModel == null || !relatedModel.hasSameID(json)) {
                            relatedModel = (StackMobModel)field.getType().newInstance();
                        }
                        relatedModel.fillFromJson(json);
                        field.set(this, relatedModel);
                    } else if (this.getMetadata(fieldName) == SerializationMetadata.MODEL_ARRAY) {
                        Class<?> actualModelClass = SerializationMetadata.getComponentClass(field);
                        Collection<StackMobModel> existingModels = this.getFieldAsCollection(field);
                        List<StackMobModel> newModels = StackMobModel.updateModelListFromJson(json.getAsJsonArray(), existingModels, actualModelClass);
                        this.setFieldFromList(field, newModels, actualModelClass);
                    } else if (this.getMetadata(fieldName) == SerializationMetadata.COUNTER) {
                        StackMobCounter counter = (StackMobCounter)field.get(this);
                        int newValue = json.getAsJsonPrimitive().getAsInt();
                        if (counter == null) {
                            counter = new StackMobCounter();
                            counter.set(newValue);
                            field.set(this, counter);
                        } else {
                            counter.set(newValue);
                        }
                    } else {
                        field.set(this, gson.fromJson(json, field.getType()));
                    }
                }
            }
        }
        catch (NoSuchFieldException e) {
            StackMob.getLogger().logDebug(String.format("Ignoring extraneous json field:\nfield: %s\ndata: %s", jsonName, json.toString()), new Object[0]);
        }
        catch (JsonSyntaxException e) {
            StackMob.getLogger().logWarning(String.format("Incoming data does not match data model:\nfield: %s\ndata: %s", jsonName, json.toString()), new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new StackMobException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new StackMobException(e.getMessage());
        }
    }

    protected Collection<StackMobModel> getFieldAsCollection(Field field) throws IllegalAccessException {
        if (field.getType().isArray()) {
            StackMobModel[] models = (StackMobModel[])field.get(this);
            return models == null ? null : Arrays.asList(models);
        }
        return (Collection)field.get(this);
    }

    protected void setFieldFromList(Field field, List<? extends StackMobModel> list, Class<? extends StackMobModel> modelClass) throws IllegalAccessException, InstantiationException {
        if (field.getType().isArray()) {
            StackMobModel[] modelArray = (StackMobModel[])field.get(this);
            if (modelArray == null || modelArray.length != list.size()) {
                field.set(this, Array.newInstance(modelClass, list.size()));
                modelArray = (StackMobModel[])field.get(this);
            }
            for (int i = 0; i < list.size(); ++i) {
                modelArray[i] = list.get(i);
            }
        } else {
            Collection models = (Collection)field.get(this);
            if (models == null) {
                this.initWithNewCollection(field);
                models = (Collection)field.get(this);
            }
            try {
                models.clear();
            }
            catch (UnsupportedOperationException e) {
                this.initWithNewCollection(field);
            }
            models.addAll(list);
        }
    }

    private void initWithNewCollection(Field field) throws IllegalAccessException {
        field.set(this, gson.fromJson("[]", field.getType()));
    }

    protected static List<StackMobModel> updateModelListFromJson(JsonArray array, Collection<? extends StackMobModel> existingModels, Class<? extends StackMobModel> modelClass) throws IllegalAccessException, InstantiationException, StackMobException {
        ArrayList<StackMobModel> result = new ArrayList<StackMobModel>();
        for (JsonElement json : array) {
            StackMobModel model = StackMobModel.getExistingModel(existingModels, json);
            if (model == null) {
                model = modelClass.newInstance();
            }
            model.fillFromJson(json);
            result.add(model);
        }
        return result;
    }

    protected static StackMobModel getExistingModel(Collection<? extends StackMobModel> oldList, JsonElement json) {
        if (oldList != null) {
            for (StackMobModel stackMobModel : oldList) {
                if (!stackMobModel.hasSameID(json)) continue;
                return stackMobModel;
            }
            for (StackMobModel stackMobModel : oldList) {
                if (stackMobModel.getID() != null) continue;
                stackMobModel.setID(json);
                return stackMobModel;
            }
        }
        return null;
    }

    private Field getField(String fieldName) throws NoSuchFieldException {
        Class<? extends StackMobModel> classToCheck = this.actualClass;
        while (!classToCheck.equals(StackMobModel.class)) {
            try {
                return classToCheck.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                classToCheck = classToCheck.getSuperclass();
            }
        }
        throw new NoSuchFieldException(fieldName);
    }

    public void fillFromJson(String jsonString) throws StackMobException {
        this.fillFromJson(new JsonParser().parse(jsonString));
    }

    protected void fillFromJson(JsonElement json) throws StackMobException {
        this.fillFromJson(json, null);
    }

    protected void fillFromJson(JsonElement json, List<String> selection) throws StackMobException {
        if (json.isJsonPrimitive()) {
            this.setID(json.getAsJsonPrimitive().getAsString());
        } else {
            for (Map.Entry jsonField : json.getAsJsonObject().entrySet()) {
                if (selection != null && !selection.contains(jsonField.getKey())) continue;
                this.fillFieldFromJson((String)jsonField.getKey(), (JsonElement)jsonField.getValue());
            }
            this.hasData = true;
        }
    }

    protected boolean hasSameID(JsonElement json) {
        if (this.getID() == null) {
            return false;
        }
        if (json.isJsonPrimitive()) {
            return this.getID().equals(json.getAsJsonPrimitive().getAsString());
        }
        JsonElement idFromJson = json.getAsJsonObject().get(this.getIDFieldName());
        return idFromJson != null && this.getID().equals(idFromJson.getAsString());
    }

    protected void setID(JsonElement json) {
        if (json.isJsonPrimitive()) {
            this.setID(json.getAsJsonPrimitive().getAsString());
        } else {
            this.setID(json.getAsJsonObject().get(this.getIDFieldName()).getAsString());
        }
    }

    private List<String> getFieldNames(JsonObject json) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : json.entrySet()) {
            list.add((String)entry.getKey());
        }
        return list;
    }

    private JsonElement toJsonElement(int depth, RelationMapping mapping) {
        if (this.getID() == null) {
            this.setID(UUID.randomUUID().toString().replace("-", ""));
        }
        if (depth < 0) {
            return new JsonPrimitive(this.getID());
        }
        JsonObject json = gson.toJsonTree((Object)this).getAsJsonObject();
        JsonObject outgoing = new JsonObject();
        for (String fieldName : this.getFieldNames(json)) {
            Field relationField;
            this.ensureValidFieldName(fieldName);
            JsonElement value = json.get(fieldName);
            if (this.getMetadata(fieldName) == SerializationMetadata.MODEL) {
                json.remove(fieldName);
                try {
                    relationField = this.getField(fieldName);
                    relationField.setAccessible(true);
                    StackMobModel relatedModel = (StackMobModel)relationField.get(this);
                    mapping.add(fieldName, relatedModel.getSchemaName());
                    JsonElement relatedJson = relatedModel.toJsonElement(depth - 1, mapping);
                    mapping.leave();
                    if (relatedJson != null) {
                        json.add(fieldName, relatedJson);
                    }
                }
                catch (Exception ignore) {}
            } else if (this.getMetadata(fieldName) == SerializationMetadata.MODEL_ARRAY) {
                json.remove(fieldName);
                try {
                    relationField = this.getField(fieldName);
                    relationField.setAccessible(true);
                    JsonArray array = new JsonArray();
                    List<StackMobModel> relatedModels = relationField.getType().isArray() ? Arrays.asList((StackMobModel[])relationField.get(this)) : (List<StackMobModel>)relationField.get(this);
                    boolean first = true;
                    for (StackMobModel relatedModel : relatedModels) {
                        JsonElement relatedJson;
                        if (first) {
                            mapping.add(fieldName, relatedModel.getSchemaName());
                            first = false;
                        }
                        if ((relatedJson = relatedModel.toJsonElement(depth - 1, mapping)) == null) continue;
                        array.add(relatedJson);
                    }
                    if (!first) {
                        mapping.leave();
                    }
                    json.add(fieldName, (JsonElement)array);
                }
                catch (Exception ignore) {}
            } else if (this.getMetadata(fieldName) == SerializationMetadata.OBJECT) {
                if (value.isJsonObject()) {
                    throw new IllegalStateException("Field " + fieldName + " is a subobject which is not supported at this time");
                }
            } else if (this.getMetadata(fieldName) == SerializationMetadata.COUNTER) {
                json.remove(fieldName);
                try {
                    StackMobCounter counter = (StackMobCounter)this.getField(fieldName).get(this);
                    switch (counter.getMode()) {
                        case INCREMENT: {
                            fieldName = fieldName + "[inc]";
                            json.add(fieldName, (JsonElement)new JsonPrimitive((Number)counter.getIncrement()));
                            break;
                        }
                        case SET: {
                            json.add(fieldName, (JsonElement)new JsonPrimitive((Number)counter.get()));
                        }
                    }
                    counter.reset();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            outgoing.add(fieldName.toLowerCase(), json.get(fieldName));
        }
        if (this.id != null) {
            outgoing.addProperty(this.getIDFieldName(), this.id);
        }
        return outgoing;
    }

    public String toJson() {
        return this.toJsonWithDepth(0);
    }

    public String toJsonWithDepth(int depth) {
        return this.toJsonWithDepth(depth, new RelationMapping());
    }

    protected String toJsonWithDepth(int depth, RelationMapping mapping) {
        return this.toJsonElement(depth, mapping).toString();
    }

    public void fetch() {
        this.fetch(new StackMobNoopCallback());
    }

    public void load(int depth) {
        this.fetchWithDepth(depth, new StackMobNoopCallback());
    }

    public void fetch(StackMobCallback callback) {
        this.fetchWithDepth(0, callback);
    }

    public void fetchWithDepth(int depth, StackMobCallback callback) {
        HashMap<String, String> args = new HashMap<String, String>();
        if (depth > 0) {
            args.put("_expand", String.valueOf(depth));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        StackMob.getStackMob().get(this.getSchemaName() + "/" + this.id, args, headers, (StackMobRawCallback)new StackMobIntermediaryCallback(callback){

            @Override
            public void success(String responseBody) {
                boolean fillSucceeded = false;
                try {
                    StackMobModel.this.fillFromJson(new JsonParser().parse(responseBody));
                    fillSucceeded = true;
                }
                catch (StackMobException e) {
                    this.failure(e);
                }
                if (fillSucceeded) {
                    super.success(responseBody);
                }
            }
        });
    }

    public void save() {
        this.save(new StackMobNoopCallback());
    }

    public void saveWithDepth(int depth) {
        this.saveWithDepth(depth, new StackMobNoopCallback());
    }

    public void save(StackMobCallback callback) {
        this.saveWithDepth(0, callback);
    }

    public void saveWithDepth(int depth, StackMobCallback callback) {
        RelationMapping mapping = new RelationMapping();
        String json = this.toJsonWithDepth(depth, mapping);
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        headers.add(new Pair<String, String>("X-StackMob-Relations", mapping.toHeaderString()));
        StackMob.getStackMob().post(this.getSchemaName(), json, headers, new StackMobIntermediaryCallback(callback){

            @Override
            public void success(String responseBody) {
                boolean fillSucceeded = false;
                try {
                    StackMobModel.this.fillFromJson(new JsonParser().parse(responseBody), Arrays.asList("lastmoddate", "createddate"));
                    fillSucceeded = true;
                }
                catch (StackMobException e) {
                    this.failure(e);
                }
                if (fillSucceeded) {
                    super.success(responseBody);
                }
            }
        });
    }

    public void destroy() {
        this.destroy(new StackMobNoopCallback());
    }

    public void destroy(StackMobCallback callback) {
        StackMob.getStackMob().delete(this.getSchemaName(), this.id, callback);
    }

    public static class DateAsNumberTypeAdapter
    extends TypeAdapter<Date> {
        public void write(JsonWriter jsonWriter, Date date) throws IOException {
            if (date == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(date.getTime());
        }

        public Date read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return new Date(jsonReader.nextLong());
        }
    }
}

