/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * AtsUpdateApplicationRequestDtoValue - The status of the application.
 */
@JsonDeserialize(using = AtsUpdateApplicationRequestDtoValue._Deserializer.class)
@JsonSerialize(using = AtsUpdateApplicationRequestDtoValue._Serializer.class)
public class AtsUpdateApplicationRequestDtoValue {

    public static final AtsUpdateApplicationRequestDtoValue ACTIVE = new AtsUpdateApplicationRequestDtoValue("active");
    public static final AtsUpdateApplicationRequestDtoValue ASSESSMENT = new AtsUpdateApplicationRequestDtoValue("assessment");
    public static final AtsUpdateApplicationRequestDtoValue BACKGROUND_CHECK = new AtsUpdateApplicationRequestDtoValue("background_check");
    public static final AtsUpdateApplicationRequestDtoValue CONVERTED = new AtsUpdateApplicationRequestDtoValue("converted");
    public static final AtsUpdateApplicationRequestDtoValue DECLINED_BY_CANDIDATE = new AtsUpdateApplicationRequestDtoValue("declined_by_candidate");
    public static final AtsUpdateApplicationRequestDtoValue HIRED = new AtsUpdateApplicationRequestDtoValue("hired");
    public static final AtsUpdateApplicationRequestDtoValue INTERVIEW = new AtsUpdateApplicationRequestDtoValue("interview");
    public static final AtsUpdateApplicationRequestDtoValue LEAD = new AtsUpdateApplicationRequestDtoValue("lead");
    public static final AtsUpdateApplicationRequestDtoValue OFFER = new AtsUpdateApplicationRequestDtoValue("offer");
    public static final AtsUpdateApplicationRequestDtoValue REFERENCE_CHECK = new AtsUpdateApplicationRequestDtoValue("reference_check");
    public static final AtsUpdateApplicationRequestDtoValue REJECTED = new AtsUpdateApplicationRequestDtoValue("rejected");
    public static final AtsUpdateApplicationRequestDtoValue REVIEW = new AtsUpdateApplicationRequestDtoValue("review");
    public static final AtsUpdateApplicationRequestDtoValue SCREEN = new AtsUpdateApplicationRequestDtoValue("screen");
    public static final AtsUpdateApplicationRequestDtoValue NEW = new AtsUpdateApplicationRequestDtoValue("new");
    public static final AtsUpdateApplicationRequestDtoValue ONBOARDING = new AtsUpdateApplicationRequestDtoValue("onboarding");
    public static final AtsUpdateApplicationRequestDtoValue CREATED = new AtsUpdateApplicationRequestDtoValue("created");
    public static final AtsUpdateApplicationRequestDtoValue ACCEPTED = new AtsUpdateApplicationRequestDtoValue("accepted");
    public static final AtsUpdateApplicationRequestDtoValue SHORT_LIST = new AtsUpdateApplicationRequestDtoValue("short_list");
    public static final AtsUpdateApplicationRequestDtoValue APPROVED = new AtsUpdateApplicationRequestDtoValue("approved");
    public static final AtsUpdateApplicationRequestDtoValue UNMAPPED_VALUE = new AtsUpdateApplicationRequestDtoValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AtsUpdateApplicationRequestDtoValue> values = createValuesMap();
    private static final Map<String, AtsUpdateApplicationRequestDtoValueEnum> enums = createEnumsMap();

    private final String value;

    private AtsUpdateApplicationRequestDtoValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AtsUpdateApplicationRequestDtoValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AtsUpdateApplicationRequestDtoValue
     */ 
    public static AtsUpdateApplicationRequestDtoValue of(String value) {
        synchronized (AtsUpdateApplicationRequestDtoValue.class) {
            return values.computeIfAbsent(value, v -> new AtsUpdateApplicationRequestDtoValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<AtsUpdateApplicationRequestDtoValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AtsUpdateApplicationRequestDtoValue other = (AtsUpdateApplicationRequestDtoValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AtsUpdateApplicationRequestDtoValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AtsUpdateApplicationRequestDtoValue[] values() {
        synchronized (AtsUpdateApplicationRequestDtoValue.class) {
            return values.values().toArray(new AtsUpdateApplicationRequestDtoValue[] {});
        }
    }

    private static final Map<String, AtsUpdateApplicationRequestDtoValue> createValuesMap() {
        Map<String, AtsUpdateApplicationRequestDtoValue> map = new LinkedHashMap<>();
        map.put("active", ACTIVE);
        map.put("assessment", ASSESSMENT);
        map.put("background_check", BACKGROUND_CHECK);
        map.put("converted", CONVERTED);
        map.put("declined_by_candidate", DECLINED_BY_CANDIDATE);
        map.put("hired", HIRED);
        map.put("interview", INTERVIEW);
        map.put("lead", LEAD);
        map.put("offer", OFFER);
        map.put("reference_check", REFERENCE_CHECK);
        map.put("rejected", REJECTED);
        map.put("review", REVIEW);
        map.put("screen", SCREEN);
        map.put("new", NEW);
        map.put("onboarding", ONBOARDING);
        map.put("created", CREATED);
        map.put("accepted", ACCEPTED);
        map.put("short_list", SHORT_LIST);
        map.put("approved", APPROVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AtsUpdateApplicationRequestDtoValueEnum> createEnumsMap() {
        Map<String, AtsUpdateApplicationRequestDtoValueEnum> map = new HashMap<>();
        map.put("active", AtsUpdateApplicationRequestDtoValueEnum.ACTIVE);
        map.put("assessment", AtsUpdateApplicationRequestDtoValueEnum.ASSESSMENT);
        map.put("background_check", AtsUpdateApplicationRequestDtoValueEnum.BACKGROUND_CHECK);
        map.put("converted", AtsUpdateApplicationRequestDtoValueEnum.CONVERTED);
        map.put("declined_by_candidate", AtsUpdateApplicationRequestDtoValueEnum.DECLINED_BY_CANDIDATE);
        map.put("hired", AtsUpdateApplicationRequestDtoValueEnum.HIRED);
        map.put("interview", AtsUpdateApplicationRequestDtoValueEnum.INTERVIEW);
        map.put("lead", AtsUpdateApplicationRequestDtoValueEnum.LEAD);
        map.put("offer", AtsUpdateApplicationRequestDtoValueEnum.OFFER);
        map.put("reference_check", AtsUpdateApplicationRequestDtoValueEnum.REFERENCE_CHECK);
        map.put("rejected", AtsUpdateApplicationRequestDtoValueEnum.REJECTED);
        map.put("review", AtsUpdateApplicationRequestDtoValueEnum.REVIEW);
        map.put("screen", AtsUpdateApplicationRequestDtoValueEnum.SCREEN);
        map.put("new", AtsUpdateApplicationRequestDtoValueEnum.NEW);
        map.put("onboarding", AtsUpdateApplicationRequestDtoValueEnum.ONBOARDING);
        map.put("created", AtsUpdateApplicationRequestDtoValueEnum.CREATED);
        map.put("accepted", AtsUpdateApplicationRequestDtoValueEnum.ACCEPTED);
        map.put("short_list", AtsUpdateApplicationRequestDtoValueEnum.SHORT_LIST);
        map.put("approved", AtsUpdateApplicationRequestDtoValueEnum.APPROVED);
        map.put("unmapped_value", AtsUpdateApplicationRequestDtoValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<AtsUpdateApplicationRequestDtoValue> {

        protected _Serializer() {
            super(AtsUpdateApplicationRequestDtoValue.class);
        }

        @Override
        public void serialize(AtsUpdateApplicationRequestDtoValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<AtsUpdateApplicationRequestDtoValue> {

        protected _Deserializer() {
            super(AtsUpdateApplicationRequestDtoValue.class);
        }

        @Override
        public AtsUpdateApplicationRequestDtoValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return AtsUpdateApplicationRequestDtoValue.of(v);
        }
    }
    
    public enum AtsUpdateApplicationRequestDtoValueEnum {

        ACTIVE("active"),
        ASSESSMENT("assessment"),
        BACKGROUND_CHECK("background_check"),
        CONVERTED("converted"),
        DECLINED_BY_CANDIDATE("declined_by_candidate"),
        HIRED("hired"),
        INTERVIEW("interview"),
        LEAD("lead"),
        OFFER("offer"),
        REFERENCE_CHECK("reference_check"),
        REJECTED("rejected"),
        REVIEW("review"),
        SCREEN("screen"),
        NEW("new"),
        ONBOARDING("onboarding"),
        CREATED("created"),
        ACCEPTED("accepted"),
        SHORT_LIST("short_list"),
        APPROVED("approved"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AtsUpdateApplicationRequestDtoValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
