/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class AttachmentValue {
    public static final AttachmentValue TEXT = new AttachmentValue("text");
    public static final AttachmentValue UNMAPPED_VALUE = new AttachmentValue("unmapped_value");
    private static final Map<String, AttachmentValue> values = AttachmentValue.createValuesMap();
    private static final Map<String, AttachmentValueEnum> enums = AttachmentValue.createEnumsMap();
    private final String value;

    private AttachmentValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttachmentValue of(String value) {
        Class<AttachmentValue> clazz = AttachmentValue.class;
        synchronized (AttachmentValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new AttachmentValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<AttachmentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttachmentValue other = (AttachmentValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "AttachmentValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttachmentValue[] values() {
        Class<AttachmentValue> clazz = AttachmentValue.class;
        synchronized (AttachmentValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new AttachmentValue[0]);
        }
    }

    private static final Map<String, AttachmentValue> createValuesMap() {
        LinkedHashMap<String, AttachmentValue> map = new LinkedHashMap<String, AttachmentValue>();
        map.put("text", TEXT);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AttachmentValueEnum> createEnumsMap() {
        HashMap<String, AttachmentValueEnum> map = new HashMap<String, AttachmentValueEnum>();
        map.put("text", AttachmentValueEnum.TEXT);
        map.put("unmapped_value", AttachmentValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum AttachmentValueEnum {
        TEXT("text"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private AttachmentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<AttachmentValue> {
        protected _Deserializer() {
            super(AttachmentValue.class);
        }

        public AttachmentValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return AttachmentValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<AttachmentValue> {
        protected _Serializer() {
            super(AttachmentValue.class);
        }

        public void serialize(AttachmentValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

