/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.CategoryLanguage;
import com.stackone.stackone_client_java.models.components.Hierarchy;
import com.stackone.stackone_client_java.models.components.Level;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Category {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private JsonNullable<String> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="remote_id")
    private JsonNullable<String> remoteId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="name")
    private JsonNullable<String> name;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="active")
    private JsonNullable<Boolean> active;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="hierarchy")
    private JsonNullable<? extends Hierarchy> hierarchy;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="level")
    @Deprecated
    private JsonNullable<? extends Level> level;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="language")
    private JsonNullable<? extends CategoryLanguage> language;

    @JsonCreator
    public Category(@JsonProperty(value="id") JsonNullable<String> id, @JsonProperty(value="remote_id") JsonNullable<String> remoteId, @JsonProperty(value="unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields, @JsonProperty(value="name") JsonNullable<String> name, @JsonProperty(value="active") JsonNullable<Boolean> active, @JsonProperty(value="hierarchy") JsonNullable<? extends Hierarchy> hierarchy, @JsonProperty(value="level") JsonNullable<? extends Level> level, @JsonProperty(value="language") JsonNullable<? extends CategoryLanguage> language) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(active, "active");
        Utils.checkNotNull(hierarchy, "hierarchy");
        Utils.checkNotNull(level, "level");
        Utils.checkNotNull(language, "language");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.name = name;
        this.active = active;
        this.hierarchy = hierarchy;
        this.level = level;
        this.language = language;
    }

    public Category() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<Boolean>)JsonNullable.undefined(), (JsonNullable<? extends Hierarchy>)JsonNullable.undefined(), (JsonNullable<? extends Level>)JsonNullable.undefined(), (JsonNullable<? extends CategoryLanguage>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> id() {
        return this.id;
    }

    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return this.remoteId;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return this.unifiedCustomFields;
    }

    @JsonIgnore
    public JsonNullable<String> name() {
        return this.name;
    }

    @JsonIgnore
    public JsonNullable<Boolean> active() {
        return this.active;
    }

    @JsonIgnore
    public JsonNullable<Hierarchy> hierarchy() {
        return this.hierarchy;
    }

    @Deprecated
    @JsonIgnore
    public JsonNullable<Level> level() {
        return this.level;
    }

    @JsonIgnore
    public JsonNullable<CategoryLanguage> language() {
        return this.language;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Category withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of((Object)id);
        return this;
    }

    public Category withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Category withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of((Object)remoteId);
        return this;
    }

    public Category withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public Category withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    public Category withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    public Category withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of((Object)name);
        return this;
    }

    public Category withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public Category withActive(boolean active) {
        Utils.checkNotNull(active, "active");
        this.active = JsonNullable.of((Object)active);
        return this;
    }

    public Category withActive(JsonNullable<Boolean> active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    public Category withHierarchy(Hierarchy hierarchy) {
        Utils.checkNotNull(hierarchy, "hierarchy");
        this.hierarchy = JsonNullable.of((Object)hierarchy);
        return this;
    }

    public Category withHierarchy(JsonNullable<? extends Hierarchy> hierarchy) {
        Utils.checkNotNull(hierarchy, "hierarchy");
        this.hierarchy = hierarchy;
        return this;
    }

    @Deprecated
    public Category withLevel(Level level) {
        Utils.checkNotNull(level, "level");
        this.level = JsonNullable.of((Object)level);
        return this;
    }

    @Deprecated
    public Category withLevel(JsonNullable<? extends Level> level) {
        Utils.checkNotNull(level, "level");
        this.level = level;
        return this;
    }

    public Category withLanguage(CategoryLanguage language) {
        Utils.checkNotNull(language, "language");
        this.language = JsonNullable.of((Object)language);
        return this;
    }

    public Category withLanguage(JsonNullable<? extends CategoryLanguage> language) {
        Utils.checkNotNull(language, "language");
        this.language = language;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Category other = (Category)o;
        return Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.remoteId, other.remoteId) && Objects.deepEquals(this.unifiedCustomFields, other.unifiedCustomFields) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.active, other.active) && Objects.deepEquals(this.hierarchy, other.hierarchy) && Objects.deepEquals(this.level, other.level) && Objects.deepEquals(this.language, other.language);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.unifiedCustomFields, this.name, this.active, this.hierarchy, this.level, this.language);
    }

    public String toString() {
        return Utils.toString(Category.class, "id", this.id, "remoteId", this.remoteId, "unifiedCustomFields", this.unifiedCustomFields, "name", this.name, "active", this.active, "hierarchy", this.hierarchy, "level", this.level, "language", this.language);
    }

    public static final class Builder {
        private JsonNullable<String> id = JsonNullable.undefined();
        private JsonNullable<String> remoteId = JsonNullable.undefined();
        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();
        private JsonNullable<String> name = JsonNullable.undefined();
        private JsonNullable<Boolean> active = JsonNullable.undefined();
        private JsonNullable<? extends Hierarchy> hierarchy = JsonNullable.undefined();
        @Deprecated
        private JsonNullable<? extends Level> level = JsonNullable.undefined();
        private JsonNullable<? extends CategoryLanguage> language = JsonNullable.undefined();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of((Object)id);
            return this;
        }

        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of((Object)remoteId);
            return this;
        }

        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of((Object)name);
            return this;
        }

        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder active(boolean active) {
            Utils.checkNotNull(active, "active");
            this.active = JsonNullable.of((Object)active);
            return this;
        }

        public Builder active(JsonNullable<Boolean> active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }

        public Builder hierarchy(Hierarchy hierarchy) {
            Utils.checkNotNull(hierarchy, "hierarchy");
            this.hierarchy = JsonNullable.of((Object)hierarchy);
            return this;
        }

        public Builder hierarchy(JsonNullable<? extends Hierarchy> hierarchy) {
            Utils.checkNotNull(hierarchy, "hierarchy");
            this.hierarchy = hierarchy;
            return this;
        }

        @Deprecated
        public Builder level(Level level) {
            Utils.checkNotNull(level, "level");
            this.level = JsonNullable.of((Object)level);
            return this;
        }

        @Deprecated
        public Builder level(JsonNullable<? extends Level> level) {
            Utils.checkNotNull(level, "level");
            this.level = level;
            return this;
        }

        public Builder language(CategoryLanguage language) {
            Utils.checkNotNull(language, "language");
            this.language = JsonNullable.of((Object)language);
            return this;
        }

        public Builder language(JsonNullable<? extends CategoryLanguage> language) {
            Utils.checkNotNull(language, "language");
            this.language = language;
            return this;
        }

        public Category build() {
            return new Category(this.id, this.remoteId, this.unifiedCustomFields, this.name, this.active, this.hierarchy, this.level, this.language);
        }
    }
}

