/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class ContentBlockStatusValue {
    public static final ContentBlockStatusValue DRAFT = new ContentBlockStatusValue("draft");
    public static final ContentBlockStatusValue LIVE = new ContentBlockStatusValue("live");
    public static final ContentBlockStatusValue ARCHIVED = new ContentBlockStatusValue("archived");
    private static final Map<String, ContentBlockStatusValue> values = ContentBlockStatusValue.createValuesMap();
    private static final Map<String, ContentBlockStatusValueEnum> enums = ContentBlockStatusValue.createEnumsMap();
    private final String value;

    private ContentBlockStatusValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentBlockStatusValue of(String value) {
        Class<ContentBlockStatusValue> clazz = ContentBlockStatusValue.class;
        synchronized (ContentBlockStatusValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new ContentBlockStatusValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<ContentBlockStatusValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentBlockStatusValue other = (ContentBlockStatusValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ContentBlockStatusValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentBlockStatusValue[] values() {
        Class<ContentBlockStatusValue> clazz = ContentBlockStatusValue.class;
        synchronized (ContentBlockStatusValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new ContentBlockStatusValue[0]);
        }
    }

    private static final Map<String, ContentBlockStatusValue> createValuesMap() {
        LinkedHashMap<String, ContentBlockStatusValue> map = new LinkedHashMap<String, ContentBlockStatusValue>();
        map.put("draft", DRAFT);
        map.put("live", LIVE);
        map.put("archived", ARCHIVED);
        return map;
    }

    private static final Map<String, ContentBlockStatusValueEnum> createEnumsMap() {
        HashMap<String, ContentBlockStatusValueEnum> map = new HashMap<String, ContentBlockStatusValueEnum>();
        map.put("draft", ContentBlockStatusValueEnum.DRAFT);
        map.put("live", ContentBlockStatusValueEnum.LIVE);
        map.put("archived", ContentBlockStatusValueEnum.ARCHIVED);
        return map;
    }

    public static enum ContentBlockStatusValueEnum {
        DRAFT("draft"),
        LIVE("live"),
        ARCHIVED("archived");

        private final String value;

        private ContentBlockStatusValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<ContentBlockStatusValue> {
        protected _Deserializer() {
            super(ContentBlockStatusValue.class);
        }

        public ContentBlockStatusValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return ContentBlockStatusValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<ContentBlockStatusValue> {
        protected _Serializer() {
            super(ContentBlockStatusValue.class);
        }

        public void serialize(ContentBlockStatusValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

