/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.ContentSourceValue;
import com.stackone.stackone_client_java.models.components.ContentValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class ContentType {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends ContentValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends ContentSourceValue> sourceValue;

    @JsonCreator
    public ContentType(@JsonProperty(value="value") JsonNullable<? extends ContentValue> value, @JsonProperty(value="source_value") JsonNullable<? extends ContentSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public ContentType() {
        this((JsonNullable<? extends ContentValue>)JsonNullable.undefined(), (JsonNullable<? extends ContentSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<ContentValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<ContentSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ContentType withValue(ContentValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public ContentType withValue(JsonNullable<? extends ContentValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public ContentType withSourceValue(ContentSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public ContentType withSourceValue(JsonNullable<? extends ContentSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentType other = (ContentType)o;
        return Objects.deepEquals(this.value, other.value) && Objects.deepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(ContentType.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends ContentValue> value = JsonNullable.undefined();
        private JsonNullable<? extends ContentSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(ContentValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends ContentValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(ContentSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends ContentSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public ContentType build() {
            return new ContentType(this.value, this.sourceValue);
        }
    }
}

