/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class ContentValue {
    public static final ContentValue VIDEO = new ContentValue("video");
    public static final ContentValue QUIZ = new ContentValue("quiz");
    public static final ContentValue DOCUMENT = new ContentValue("document");
    public static final ContentValue AUDIO = new ContentValue("audio");
    public static final ContentValue ARTICLE = new ContentValue("article");
    private static final Map<String, ContentValue> values = ContentValue.createValuesMap();
    private static final Map<String, ContentValueEnum> enums = ContentValue.createEnumsMap();
    private final String value;

    private ContentValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentValue of(String value) {
        Class<ContentValue> clazz = ContentValue.class;
        synchronized (ContentValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new ContentValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<ContentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentValue other = (ContentValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ContentValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentValue[] values() {
        Class<ContentValue> clazz = ContentValue.class;
        synchronized (ContentValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new ContentValue[0]);
        }
    }

    private static final Map<String, ContentValue> createValuesMap() {
        LinkedHashMap<String, ContentValue> map = new LinkedHashMap<String, ContentValue>();
        map.put("video", VIDEO);
        map.put("quiz", QUIZ);
        map.put("document", DOCUMENT);
        map.put("audio", AUDIO);
        map.put("article", ARTICLE);
        return map;
    }

    private static final Map<String, ContentValueEnum> createEnumsMap() {
        HashMap<String, ContentValueEnum> map = new HashMap<String, ContentValueEnum>();
        map.put("video", ContentValueEnum.VIDEO);
        map.put("quiz", ContentValueEnum.QUIZ);
        map.put("document", ContentValueEnum.DOCUMENT);
        map.put("audio", ContentValueEnum.AUDIO);
        map.put("article", ContentValueEnum.ARTICLE);
        return map;
    }

    public static enum ContentValueEnum {
        VIDEO("video"),
        QUIZ("quiz"),
        DOCUMENT("document"),
        AUDIO("audio"),
        ARTICLE("article");

        private final String value;

        private ContentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<ContentValue> {
        protected _Deserializer() {
            super(ContentValue.class);
        }

        public ContentValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return ContentValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<ContentValue> {
        protected _Serializer() {
            super(ContentValue.class);
        }

        public void serialize(ContentValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

