/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.LinkedAccountMetaCategory;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Map;
import java.util.Objects;

public class LinkedAccountMeta {
    @JsonProperty(value="provider")
    private String provider;
    @JsonProperty(value="category")
    private LinkedAccountMetaCategory category;
    @JsonProperty(value="models")
    private Map<String, Object> models;

    @JsonCreator
    public LinkedAccountMeta(@JsonProperty(value="provider") String provider, @JsonProperty(value="category") LinkedAccountMetaCategory category, @JsonProperty(value="models") Map<String, Object> models) {
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(category, "category");
        models = Utils.emptyMapIfNull(models);
        this.provider = provider;
        this.category = category;
        this.models = models;
    }

    @JsonIgnore
    public String provider() {
        return this.provider;
    }

    @JsonIgnore
    public LinkedAccountMetaCategory category() {
        return this.category;
    }

    @JsonIgnore
    public Map<String, Object> models() {
        return this.models;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public LinkedAccountMeta withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public LinkedAccountMeta withCategory(LinkedAccountMetaCategory category) {
        Utils.checkNotNull(category, "category");
        this.category = category;
        return this;
    }

    public LinkedAccountMeta withModels(Map<String, Object> models) {
        Utils.checkNotNull(models, "models");
        this.models = models;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkedAccountMeta other = (LinkedAccountMeta)o;
        return Objects.deepEquals(this.provider, other.provider) && Objects.deepEquals(this.category, other.category) && Objects.deepEquals(this.models, other.models);
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.category, this.models);
    }

    public String toString() {
        return Utils.toString(LinkedAccountMeta.class, "provider", this.provider, "category", this.category, "models", this.models);
    }

    public static final class Builder {
        private String provider;
        private LinkedAccountMetaCategory category;
        private Map<String, Object> models;

        private Builder() {
        }

        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        public Builder category(LinkedAccountMetaCategory category) {
            Utils.checkNotNull(category, "category");
            this.category = category;
            return this;
        }

        public Builder models(Map<String, Object> models) {
            Utils.checkNotNull(models, "models");
            this.models = models;
            return this;
        }

        public LinkedAccountMeta build() {
            return new LinkedAccountMeta(this.provider, this.category, this.models);
        }
    }
}

