/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateJobRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;

public class AtsCreateJobRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsCreateJobRequestDto atsCreateJobRequestDto;

    @JsonCreator
    public AtsCreateJobRequest(String xAccountId, AtsCreateJobRequestDto atsCreateJobRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(atsCreateJobRequestDto, "atsCreateJobRequestDto");
        this.xAccountId = xAccountId;
        this.atsCreateJobRequestDto = atsCreateJobRequestDto;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public AtsCreateJobRequestDto atsCreateJobRequestDto() {
        return this.atsCreateJobRequestDto;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsCreateJobRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsCreateJobRequest withAtsCreateJobRequestDto(AtsCreateJobRequestDto atsCreateJobRequestDto) {
        Utils.checkNotNull(atsCreateJobRequestDto, "atsCreateJobRequestDto");
        this.atsCreateJobRequestDto = atsCreateJobRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsCreateJobRequest other = (AtsCreateJobRequest)o;
        return Objects.deepEquals(this.xAccountId, other.xAccountId) && Objects.deepEquals(this.atsCreateJobRequestDto, other.atsCreateJobRequestDto);
    }

    public int hashCode() {
        return Objects.hash(this.xAccountId, this.atsCreateJobRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsCreateJobRequest.class, "xAccountId", this.xAccountId, "atsCreateJobRequestDto", this.atsCreateJobRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private AtsCreateJobRequestDto atsCreateJobRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder atsCreateJobRequestDto(AtsCreateJobRequestDto atsCreateJobRequestDto) {
            Utils.checkNotNull(atsCreateJobRequestDto, "atsCreateJobRequestDto");
            this.atsCreateJobRequestDto = atsCreateJobRequestDto;
            return this;
        }

        public AtsCreateJobRequest build() {
            return new AtsCreateJobRequest(this.xAccountId, this.atsCreateJobRequestDto);
        }
    }
}

